<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');
session_start();

$assignmentTitle = trim($_POST['assignmentTitle'] ?? '');
$rawQuestions = $_POST['selected_questions'] ?? '';

if (empty($assignmentTitle)) {
    echo json_encode(["status" => "error", "message" => "Assignment title is required."]);
    exit;
}

if (empty($rawQuestions)) {
    echo json_encode(["status" => "error", "message" => "Please select at least one question."]);
    exit;
}

$questionIds = json_decode($rawQuestions, true);


try {
    $user_id = $_SESSION['user_id'] ?? 0;
    $institute_id = $_SESSION['institute_id'] ?? 0;

    $questionIdsString = implode(',', array_map('intval', $questionIds));

    $insertQuizSql = "INSERT INTO assignment_master (assignment_title, created_by, institute_id, question_ids) 
                      VALUES (:assignment_title, :created_by, :institute_id, :question_ids)";
    $stmt = $pdo->prepare($insertQuizSql);
    $stmt->bindParam(':assignment_title', $assignmentTitle);
    $stmt->bindParam(':created_by', $user_id);
    $stmt->bindParam(':institute_id', $institute_id);
    $stmt->bindParam(':question_ids', $questionIdsString);
    $stmt->execute();

    echo json_encode(["status" => "success", "message" => "Assignment created successfully!"]);

} catch (PDOException $e) {
    error_log("Quiz Insert Error: " . $e->getMessage());
    echo json_encode(["status" => "error", "message" => "An error occurred while processing your request."]);
}