<?php
session_start();
require_once('../includes/connection.php');
require('../vendor/autoload.php'); // Vimeo

header('Content-Type: application/json');

$targetDir = "../images/course_image/";
if (!is_dir($targetDir)) {
    mkdir($targetDir, 0777, true);
}

try {
    $draft_id = isset($_POST['draft_id']) ? intval($_POST['draft_id']) : 0;
    if ($draft_id <= 0) {
        echo json_encode(["status" => "error", "message" => "Invalid draft ID."]);
        exit();
    }

    $institute_id = $_SESSION['institute_id'] ?? 0;
    $user_id = $_SESSION['user_id'] ?? 0;

    // Collect form fields
    $course_title = trim($_POST['course_title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $category = $_POST['category'] ?? 0;
    $mentor_ids = isset($_POST['mentor']) ? implode(',', $_POST['mentor']) : '';
    $industry_expert_ids = $_POST['industry_expert'] ?? '';
    $level = $_POST['level'] ?? 1;
    $start_date = $_POST['schedule_from'] ?? '';
    $end_date = $_POST['schedule_to'] ?? '';
    $testimonials = isset($_POST['testimonial']) ? implode(',', $_POST['testimonial']) : '';
    $proposed_courses = $_POST['proposed_courses'] ?? '';
    $language = $_POST['language'] ?? '';
    $faq_ids = $_POST['faq_ids'] ?? '';
    $updated_date = date('Y-m-d H:i:s');

    // Image upload
    $updateImage = false;
    $course_img = '';
    if (!empty($_FILES['course_img']['name'])) {
        $fileName = time() . '_' . basename($_FILES['course_img']['name']);
        $targetFile = $targetDir . $fileName;
        if (move_uploaded_file($_FILES['course_img']['tmp_name'], $targetFile)) {
            $course_img = $fileName;
            $updateImage = true;
        } else {
            echo json_encode(["status" => "error", "message" => "Image upload failed."]);
            exit();
        }
    }

    // Update course_draft
    $sql = "UPDATE course_draft SET 
        course_title = :course_title,
        course_description = :course_description,
        course_category = :course_category,
        mentor_ids = :mentor_ids,
        industry_expert_ids = :industry_expert_ids,
        level = :level,
        start_date = :start_date,
        end_date = :end_date,
        testimonials = :testimonials,
        proposed_courses = :proposed_courses,
        language = :language,
        faq_ids = :faq_ids";

    if ($updateImage) {
        $sql .= ", course_img = :course_img";
    }

    $sql .= " WHERE draft_id = :draft_id";

    $stmt = $pdo->prepare($sql);

    $params = [
        ':course_title' => $course_title,
        ':course_description' => $description,
        ':course_category' => $category,
        ':mentor_ids' => $mentor_ids,
        ':industry_expert_ids' => $industry_expert_ids,
        ':level' => $level,
        ':start_date' => $start_date,
        ':end_date' => $end_date,
        ':testimonials' => $testimonials,
        ':proposed_courses' => $proposed_courses,
        ':language' => $language,
        ':faq_ids' => $faq_ids,
        ':draft_id' => $draft_id
    ];

    if ($updateImage) {
        $params[':course_img'] = $course_img;
    }

    $stmt->execute($params);

    /** ============================
     * MODULE INSERTION
     * ============================ */
    if (!empty($_POST['module_name'])) {
        $modules = json_decode($_POST['module_name'], true); // Expects array of module objects
        foreach ($modules as $mod) {
            $modName = $mod['module_name'];
            $submodules = isset($mod['submodule_name']) ? implode(',', $mod['submodule_name']) : '';
            $modDesc = $mod['description'] ?? '';
            $isActive = $mod['is_active'] ?? 1;

            // Check if exists
            $modStmt = $pdo->prepare("SELECT COUNT(*) FROM module_master WHERE module_name = :name AND institute_id = :institute_id");
            $modStmt->execute([':name' => $modName, ':institute_id' => $institute_id]);

            if ($modStmt->fetchColumn() == 0) {
                $insertMod = $pdo->prepare("INSERT INTO module_master (module_name, sub_module_id, description, created_by, institute_id, is_active) 
                                            VALUES (:name, :submodules, :desc, :uid, :iid, :active)");
                $insertMod->execute([
                    ':name' => $modName,
                    ':submodules' => $submodules,
                    ':desc' => $modDesc,
                    ':uid' => $user_id,
                    ':iid' => $institute_id,
                    ':active' => $isActive
                ]);
            }
        }
    }

    /** ============================
     * STUDY MATERIAL UPLOAD
     * ============================ */
    if (!empty($_FILES['study_files']['name'][0])) {
        $client = new \Vimeo\Vimeo("5aa41d66ac6c8c8f7ac864af4455b38e58124df5", "f9VSklt+8WdIEFjYZAR5Q+gdo6Nu6z+ZgJWPpcCeuQWsEpOG8ksBRHLJlnRgl0mJ6QyJv6Khcf5tiP4AplxYCpoeTlKisXZAUz5LombPknL7wTfpSmbdtupJGW/7OBM5", "59049690f9eb19c23cd3aaa17a2c759e");

        foreach ($_FILES['study_files']['name'] as $i => $name) {
            $tmpPath = $_FILES['study_files']['tmp_name'][$i];
            $type = mime_content_type($tmpPath);
            $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
            $title = $_POST['study_title'][$i];
            $desc = $_POST['study_desc'][$i];
            $category = $_POST['course_category'];

            if (str_starts_with($type, 'video/')) {
                $uri = $client->upload($tmpPath, ["name" => $title, "description" => $desc]);
                $vidResp = $client->request($uri . '?fields=link');
                $video_link = $vidResp['body']['link'];
                $vimeo_id = explode("/", $video_link)[3];

                $pdo->prepare("INSERT INTO study_material (vimeo_link, title, description, category_id) 
                               VALUES (:link, :title, :desc, :cat)")
                    ->execute([
                        ':link' => $vimeo_id,
                        ':title' => $title,
                        ':desc' => $desc,
                        ':cat' => $category
                    ]);
            } else {
                $uploadDir = '../study/';
                if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);
                $target = $uploadDir . basename($name);
                if (move_uploaded_file($tmpPath, $target)) {
                    $pdo->prepare("INSERT INTO study_material (actual_file_name, title, description, category_id) 
                                   VALUES (:fname, :title, :desc, :cat)")
                        ->execute([
                            ':fname' => $name,
                            ':title' => $title,
                            ':desc' => $desc,
                            ':cat' => $category
                        ]);
                }
            }
        }
    }

    echo json_encode(["status" => "success", "message" => "Course draft updated and modules/materials saved."]);

} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
