<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$response = ["status" => "error", "message" => "An unexpected error occurred."];

// Sanitize inputs
$instituteName = trim($_POST['institute_name']);
$phone_no = trim($_POST['phone_no']);
$email_id = trim($_POST['email_id']);
$password = base64_encode(trim($_POST['password']));
$city = trim($_POST['city'] ?? '');
$state = trim($_POST['state'] ?? '');
$country = trim($_POST['country'] ?? '');
$pincode = trim($_POST['pincode'] ?? '');
$blockInstitute = $_POST['block_institute'];
$selectedCoursesArray = $_POST['course'] ?? [];

try {
    $createdby_id = 1;
    $category = 'institute';
    $pdo->beginTransaction();

    // Check duplicate email
    $checkEmailStmt = $pdo->prepare("SELECT COUNT(*) FROM user_master WHERE email_id = :email_id");
    $checkEmailStmt->bindValue(':email_id', $email_id);
    $checkEmailStmt->execute();
    if ($checkEmailStmt->fetchColumn() > 0) {
        $pdo->rollBack();
        echo json_encode(["status" => "error", "message" => "Email ID already exists."]);
        exit();
    }

    // Check duplicate phone
    $checkPhoneStmt = $pdo->prepare("SELECT COUNT(*) FROM user_master WHERE phone_no = :phone_no");
    $checkPhoneStmt->bindValue(':phone_no', $phone_no);
    $checkPhoneStmt->execute();
    if ($checkPhoneStmt->fetchColumn() > 0) {
        $pdo->rollBack();
        echo json_encode(["status" => "error", "message" => "Phone number already exists."]);
        exit();
    }
    

    $checkInstituteStmt = $pdo->prepare("SELECT COUNT(*) FROM institute_master 
                                         WHERE institute_name = :name AND is_deleted != 1");
    $checkInstituteStmt->bindValue(':name', $instituteName);
    $checkInstituteStmt->execute();
    
    if ($checkInstituteStmt->fetchColumn() > 0) {
        $pdo->rollBack();
        echo json_encode(["status" => "error", "message" => "Institute name already exists."]);
        exit();
    }


    // Insert into user_master
    $insertUserStmt = $pdo->prepare("INSERT INTO user_master (category, email_id, phone_no, password, user_name, created_by, is_block)
                                     VALUES (:category, :email_id, :phone_no, :password, :user_name, :created_by, :is_block)");
    $insertUserStmt->bindValue(':category', $category);
    $insertUserStmt->bindValue(':email_id', $email_id);
    $insertUserStmt->bindValue(':phone_no', $phone_no);
    $insertUserStmt->bindValue(':password', $password);
    $insertUserStmt->bindValue(':user_name', $instituteName);
    $insertUserStmt->bindValue(':created_by', $createdby_id);
    $insertUserStmt->bindValue(':is_block', $blockInstitute);
    $insertUserStmt->execute();
    $user_id = $pdo->lastInsertId();

    // Generate unique folder name
    $folderName = hash('sha256', uniqid('', true));
    $instituteImgFilename = ''; // Placeholder

    // Insert into institute_master (initially with empty image and without courses)
    $insertInstituteStmt = $pdo->prepare("INSERT INTO institute_master (
        institute_name, phone_no, email_id, city, state, country, pincode, created_by,
        user_id, password, is_block, institute_img, folder_name
    ) VALUES (
        :institute_name, :phone_no, :email_id, :city, :state, :country, :pincode, :created_by,
        :user_id, :password, :is_block, :institute_img, :folder_name
    )");
    $insertInstituteStmt->bindValue(':institute_name', $instituteName);
    $insertInstituteStmt->bindValue(':phone_no', $phone_no);
    $insertInstituteStmt->bindValue(':email_id', $email_id);
    $insertInstituteStmt->bindValue(':city', $city);
    $insertInstituteStmt->bindValue(':state', $state);
    $insertInstituteStmt->bindValue(':country', $country);
    $insertInstituteStmt->bindValue(':pincode', $pincode);
    $insertInstituteStmt->bindValue(':created_by', $createdby_id);
    $insertInstituteStmt->bindValue(':user_id', $user_id);
    $insertInstituteStmt->bindValue(':password', $password);
    $insertInstituteStmt->bindValue(':is_block', $blockInstitute);
    $insertInstituteStmt->bindValue(':institute_img', $instituteImgFilename);
    $insertInstituteStmt->bindValue(':folder_name', $folderName);
    $insertInstituteStmt->execute();
    $institute_id = $pdo->lastInsertId();

    // Insert into institute_courses
    if (!empty($selectedCoursesArray) && is_array($selectedCoursesArray)) {
        $insertCourseStmt = $pdo->prepare("INSERT INTO institute_courses (institute_id, course_id) VALUES (:institute_id, :course_id)");
        foreach ($selectedCoursesArray as $course_id) {
            if (!empty($course_id)) {
                $insertCourseStmt->bindValue(':institute_id', $institute_id);
                $insertCourseStmt->bindValue(':course_id', $course_id);
                $insertCourseStmt->execute();
            }
        }
    }

    // Update user_master with institute_id
    $updateUserStmt = $pdo->prepare("UPDATE user_master SET institute_id = :institute_id WHERE user_id = :user_id");
    $updateUserStmt->bindValue(':institute_id', $institute_id);
    $updateUserStmt->bindValue(':user_id', $user_id);
    $updateUserStmt->execute();

    // Create folders
    $folderPath = '../institutes/' . $folderName;
    $subfolders = ['institute_images', 'mentor_images', 'question_images', 'study_materials', 'course_images'];

    foreach ($subfolders as $subfolder) {
        $subfolderPath = $folderPath . '/' . $subfolder;
        if (!mkdir($subfolderPath, 0755, true)) {
            $pdo->rollBack();
            echo json_encode(["status" => "error", "message" => "Failed to create subfolder: $subfolder"]);
            exit();
        }
        file_put_contents($subfolderPath . '/index.html', '');
    }

    // Move uploaded image (if exists)
    if (isset($_FILES['institute_img']) && $_FILES['institute_img']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['institute_img']['tmp_name'];
        $fileName = basename($_FILES['institute_img']['name']);
        $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        $newFileName = uniqid('institute_', true) . '.' . $fileExt;
        $uploadDir = $folderPath . '/institute_images/';
        $destPath = $uploadDir . $newFileName;

        if (move_uploaded_file($fileTmpPath, $destPath)) {
            $instituteImgFilename = $newFileName;

            // Update image filename in DB
            $updateImgStmt = $pdo->prepare("UPDATE institute_master SET institute_img = :img WHERE institute_id = :id");
            $updateImgStmt->bindValue(':img', $instituteImgFilename);
            $updateImgStmt->bindValue(':id', $institute_id);
            $updateImgStmt->execute();
        } else {
            $pdo->rollBack();
            echo json_encode(["status" => "error", "message" => "Failed to move institute image."]);
            exit();
        }
    }

    // Add contact persons
    if (!empty($_POST['contact_name']) && is_array($_POST['contact_name'])) {
        $contacts = array_map(null, $_POST['contact_name'], $_POST['contact_phone'], $_POST['contact_email']);
        $insertContactStmt = $pdo->prepare("INSERT INTO institute_contact_person (institute_id, contact_name, mobile_no, email_id)
                                            VALUES (:institute_id, :name, :phone, :email)");
        foreach ($contacts as $contact) {
            list($name, $phone, $email) = $contact;
            if (empty($name) && empty($phone) && empty($email)) continue;

            $insertContactStmt->bindValue(':institute_id', $institute_id);
            $insertContactStmt->bindValue(':name', trim($name));
            $insertContactStmt->bindValue(':phone', trim($phone));
            $insertContactStmt->bindValue(':email', trim($email));
            $insertContactStmt->execute();
        }
    }

    $pdo->commit();
    echo json_encode(["status" => "success", "message" => "Institute created successfully!"]);
} catch (PDOException $e) {
    $pdo->rollBack();
    error_log("Add Institute Error: " . $e->getMessage());
    echo json_encode(["status" => "error", "message" => "An error occurred while creating the institute."]);
}
?>