<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if (isset($_POST['mentor_name']) && !empty($_POST['mentor_name'])) {
    $mentorName = trim($_POST['mentor_name']);
    $phone_no = $_POST['phone_no'] ?? '';
    $email_id = $_POST['email_id'] ?? '';
    $password = $_POST['password'] ?? '';
    $encoded_password = base64_encode($password);

    $specialization = $_POST['specialization'] ?? '';
    $linkedin_profile = $_POST['linkedin_profile'] ?? '';
    $block_mentor = $_POST['block_mentor'] ?? '0';
    $industry_expert = $_POST['industry_expert'] ?? '0';

    try {
        $user_id = $_SESSION['user_id'];
        $institute_id = $_SESSION['institute_id'];

        // Check for duplicate email
        $checkEmail = $pdo->prepare("SELECT COUNT(*) FROM user_master WHERE email_id = :email_id");
        $checkEmail->execute([':email_id' => $email_id]);
        if ($checkEmail->fetchColumn() > 0) {
            echo json_encode(["status" => "error", "message" => "Email ID already exists."]);
            exit;
        }

        // Check for duplicate phone
        $checkPhone = $pdo->prepare("SELECT COUNT(*) FROM user_master WHERE phone_no = :phone_no");
        $checkPhone->execute([':phone_no' => $phone_no]);
        if ($checkPhone->fetchColumn() > 0) {
            echo json_encode(["status" => "error", "message" => "Phone number already exists."]);
            exit;
        }


	$category = ($industry_expert == '1') ? 'expert' : 'mentor';

        $insertUserSql = "INSERT INTO user_master (
            user_name, email_id, password, phone_no, institute_id, category, is_block, created_by
        ) VALUES (
            :user_name, :email_id, :password, :phone_no, :institute_id, :category, :is_block, :created_by
        )";

        $insertUserStmt = $pdo->prepare($insertUserSql);
        $insertUserStmt->bindParam(':user_name', $mentorName);
        $insertUserStmt->bindParam(':email_id', $email_id);
        $insertUserStmt->bindParam(':password', $encoded_password);
        $insertUserStmt->bindParam(':phone_no', $phone_no);
        $insertUserStmt->bindParam(':institute_id', $institute_id);
        $insertUserStmt->bindValue(':category', $category);
        $insertUserStmt->bindParam(':created_by', $user_id);
        $insertUserStmt->bindParam(':is_block', $block_mentor);

        $insertUserStmt->execute();

        $mentor_user_id = $pdo->lastInsertId();

        // Get institute folder name
        $stmt = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
        $stmt->execute([':institute_id' => $institute_id]);
        $folderName = $stmt->fetchColumn();

        if (!$folderName) {
            throw new Exception("Institute folder not found.");
        }

        $uploadDir = '../institutes/' . $folderName . '/mentor_images/';

        // Upload mentor image
        $mentorImgPath = '';
        if (isset($_FILES['mentor_img']) && $_FILES['mentor_img']['error'] === UPLOAD_ERR_OK) {
            $fileName = $_FILES['mentor_img']['name'];
            $tmpPath = $_FILES['mentor_img']['tmp_name'];
            $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
            $encryptedFileName = hash('sha256', uniqid('', true)) . '.' . $fileExt;
            $targetPath = $uploadDir . $encryptedFileName;

            if (!move_uploaded_file($tmpPath, $targetPath)) {
                throw new Exception("Failed to upload mentor image.");
            }

            $mentorImgPath = $encryptedFileName;
        }

        // Upload mentor CV (optional)
        $mentorCVPath = '';
        if (isset($_FILES['mentor_cv']) && $_FILES['mentor_cv']['error'] === UPLOAD_ERR_OK) {
            $cvName = $_FILES['mentor_cv']['name'];
            $cvTmpPath = $_FILES['mentor_cv']['tmp_name'];
            $cvExt = strtolower(pathinfo($cvName, PATHINFO_EXTENSION));
            $encryptedCVName = hash('sha256', uniqid('', true)) . '.' . $cvExt;
            $cvTargetPath = $uploadDir . $encryptedCVName;

            if (!move_uploaded_file($cvTmpPath, $cvTargetPath)) {
                throw new Exception("Failed to upload mentor CV.");
            }

            $mentorCVPath = $encryptedCVName;
        }

        // Insert mentor data (user_id = user_master PK)
        $insertSql = "INSERT INTO mentor_master (
            user_id, mentor_name, phone_no, email_id, password, specialization, linkedin_profile,
            photo, cv, is_block, industry_expert, created_by, institute_id
        ) VALUES (
            :user_id, :mentor_name, :phone_no, :email_id, :password, :specialization, :linkedin_profile,
            :mentor_img, :mentor_cv, :block_mentor, :industry_expert, :created_by, :institute_id
        )";

        $insertStmt = $pdo->prepare($insertSql);

        $insertStmt->bindParam(':user_id', $mentor_user_id);
        $insertStmt->bindParam(':mentor_name', $mentorName);
        $insertStmt->bindParam(':phone_no', $phone_no);
        $insertStmt->bindParam(':email_id', $email_id);
        $insertStmt->bindParam(':password', $encoded_password);
        $insertStmt->bindParam(':specialization', $specialization);
        $insertStmt->bindParam(':linkedin_profile', $linkedin_profile);
        $insertStmt->bindParam(':mentor_img', $mentorImgPath);
        $insertStmt->bindParam(':mentor_cv', $mentorCVPath);
        $insertStmt->bindParam(':block_mentor', $block_mentor);
        $insertStmt->bindParam(':industry_expert', $industry_expert);
        $insertStmt->bindParam(':created_by', $user_id);
        $insertStmt->bindParam(':institute_id', $institute_id);

        $insertStmt->execute();

        echo json_encode(["status" => "success", "message" => "Mentor created successfully!"]);

    } catch (Exception $e) {
        echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Mentor name is required."]);
}