<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['submodule_name']) && !empty($data['submodule_name']) && !empty($data['module_id'])) {
    $submoduleName = trim($data['submodule_name']);
    $description = isset($data['description']) ? $data['description'] : '';
    $module_id = isset($data['module_id']) ? $data['module_id'] : '';
    $status = isset($data['status']) ? $data['status'] : '';

} else {
    echo json_encode(["status" => "error", "message" => "Submodule name is required"]);
    exit();
}

try {
    $user_id = $_SESSION['user_id'];
    $institute_id = $_SESSION['institute_id'];

    // Prepare the SQL query to check if the submodule_name already exists
    $checkSql = "SELECT COUNT(*) FROM submodule_master WHERE submodule_name = :submodule_name AND institute_id = :institute_id";
    $checkStmt = $pdo->prepare($checkSql);

    $checkStmt->bindParam(':submodule_name', $submoduleName);
    $checkStmt->bindParam(':institute_id', $institute_id);
    $checkStmt->execute();
    $count = $checkStmt->fetchColumn();

    if ($count > 0) {
        echo json_encode(["status" => "error","message" => "Submodule already exists."]);
    } else {
        $insertSql = "INSERT INTO submodule_master (submodule_name, module_id, description, created_by, institute_id, is_block) 
                      VALUES (:submodule_name, :module_id ,:description, :user_id, :institute_id, :status)";
        $insertStmt = $pdo->prepare($insertSql);

        // Bind the parameters and execute the insert statement
        $insertStmt->bindParam(':submodule_name', $submoduleName);
        $insertStmt->bindParam(':module_id', $module_id);
        $insertStmt->bindParam(':description', $description);
        $insertStmt->bindParam(':user_id', $user_id);
        $insertStmt->bindParam(':institute_id', $institute_id);
        $insertStmt->bindParam(':status', $status);
        $insertStmt->execute();

        echo json_encode(["status" => "success","message" => "Submodule created successfully!"]);
    }

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}

?>