<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$institute_id = $_SESSION['institute_id'];

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'am.assignment_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');

    // Allowed fields to sort by
    $allowedSortFields = ['am.assignment_title', 'am.is_block', 'am.assignment_id'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'am.assignment_id';
    }

    // Base WHERE clause (institute + status)
    $whereClause = "WHERE am.is_deleted !=1 AND am.is_block != 1 AND (am.institute_id = :institute_id OR am.institute_id = 0)";
    $params = [':institute_id' => $institute_id];

    // Search filter
    if (!empty($searchValue)) {
        $whereClause .= " AND am.assignment_title LIKE :search";
        $params[':search'] = '%' . $searchValue . '%';
    }

    // Total records (no filter)
    $totalQuery = "
        SELECT COUNT(*) 
        FROM assignment_master am 
        WHERE am.is_block != 1 AND (am.institute_id = :institute_id OR am.institute_id = 0)
    ";
    $totalStmt = $pdo->prepare($totalQuery);
    $totalStmt->execute([':institute_id' => $institute_id]);
    $recordsTotal = $totalStmt->fetchColumn();

    // Filtered records
    $filteredQuery = "
        SELECT COUNT(*) 
        FROM assignment_master am 
        $whereClause
    ";
    $filteredStmt = $pdo->prepare($filteredQuery);
    $filteredStmt->execute($params);
    $recordsFiltered = $filteredStmt->fetchColumn();

    // Fetch paginated data
    $dataQuery = "
        SELECT 
            am.assignment_id,
            am.assignment_title,
            am.is_block
        FROM assignment_master am
        $whereClause
        ORDER BY $sortField $sortDir
        LIMIT :start, :length
    ";
    $dataStmt = $pdo->prepare($dataQuery);
    foreach ($params as $key => $val) {
        $dataStmt->bindValue($key, $val);
    }
    $dataStmt->bindValue(':start', $start, PDO::PARAM_INT);
    $dataStmt->bindValue(':length', $length, PDO::PARAM_INT);
    $dataStmt->execute();

    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($recordsTotal),
        'recordsFiltered' => intval($recordsFiltered),
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode(['error' => true, 'message' => $e->getMessage()]);
}