<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw        = $_POST['draw'] ?? 1;
    $start       = (int)($_POST['start'] ?? 0);
    $length      = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField   = $_POST['sortField'] ?? 'qm.question_master_id';
    $sortDir     = strtoupper($_POST['sortDir'] ?? 'DESC');
    $category_id = $_POST['category_id'] ?? '';
    $criteria    = $_POST['criteria'] ?? '';
    $selected_ids = $_POST['selected_ids'] ?? '';

    if (!in_array($sortDir, ['ASC','DESC'])) $sortDir = 'DESC';
    $allowedSortFields = ['qm.question_master_id','qm.question','cm.category_name','qm.criteria','qm.media'];
    if (!in_array($sortField,$allowedSortFields)) $sortField = 'qm.question_master_id';

    $searchQuery = "WHERE qm.is_deleted != 1";
    $searchParams = [];

    // If selected_ids provided → only show those
    if (!empty($selected_ids)) {
        $idsArray = array_filter(array_map('trim', explode(',', $selected_ids)));
        if (!empty($idsArray)) {
            $placeholders = implode(',', array_fill(0, count($idsArray), '?'));
            $searchQuery .= " AND qm.question_master_id IN ($placeholders)";
            $searchParams = array_merge($searchParams, $idsArray);
        }
    } else {
        if (!empty($category_id)) {
            $searchQuery .= " AND qm.category_course_id = ?";
            $searchParams[] = $category_id;
        }
        if (!empty($criteria)) {
            $searchQuery .= " AND qm.criteria = ?";
            $searchParams[] = $criteria;
        }
        if (!empty($searchValue)) {
            $like = "%$searchValue%";
            $searchQuery .= " AND (qm.question LIKE ? OR cm.category_name LIKE ? OR qm.criteria LIKE ? OR qm.media LIKE ?";
            $searchParams = array_merge($searchParams, [$like, $like, $like, $like]);

            if (stripos($searchValue, 'inactive') !== false) {
                $searchQuery .= " OR qm.is_block = ?";
                $searchParams[] = '1';
            } elseif (stripos($searchValue, 'active') !== false) {
                $searchQuery .= " OR qm.is_block = ?";
                $searchParams[] = '0';
            }

            $searchQuery .= ")";
        }
    }

    $totalRecords = $pdo->query("SELECT COUNT(*) FROM question_master WHERE is_deleted != 1")->fetchColumn();

    if (!empty($searchParams)) {
        $filteredStmt = $pdo->prepare("
            SELECT COUNT(*) 
            FROM question_master qm
            LEFT JOIN category_master cm ON qm.category_course_id = cm.category_id
            $searchQuery
        ");
        $filteredStmt->execute($searchParams);
        $filteredRecords = $filteredStmt->fetchColumn();
    } else {
        $filteredRecords = $totalRecords;
    }

    $dataSql = "
        SELECT 
            qm.question_master_id, 
            qm.question,
            qm.criteria,
            cm.category_name,
            qm.media,
            qm.marks,
            qm.duration
        FROM question_master qm
        LEFT JOIN category_master cm ON qm.category_course_id = cm.category_id
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $dataStmt = $pdo->prepare($dataSql);
    $dataStmt->execute(array_merge($searchParams, [$start, $length]));
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode(['error' => true, 'message' => $e->getMessage()]);
}
