<?php
session_start();
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField =  'course_id';
    $sortDir = 'ASC';
    $categoryId = $_POST['category_id'] ?? null;

    // Allowable sort fields
    $allowedSortFields = ['course_title', 'start_date', 'course_fees', 'no_of_licenses'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'course_id';
    }

    // Build search & filter query
    $searchQuery = "WHERE c.is_block = 0";
    $params = [];

    // Filter by category if provided
    if (!empty($categoryId)) {
        $searchQuery .= " AND c.course_category = :category_id";
        $params[':category_id'] = $categoryId;
    }

    if (!empty($searchValue)) {
        $searchQuery .= " AND (
            c.course_title LIKE :search_title OR
            c.start_date LIKE :search_start OR
            c.course_fees LIKE :search_fees OR
            c.no_of_licenses LIKE :search_licenses
        )";

        $params[':search_title'] = '%' . $searchValue . '%';
        $params[':search_start'] = '%' . $searchValue . '%';
        $params[':search_fees'] = '%' . $searchValue . '%';
        $params[':search_licenses'] = '%' . $searchValue . '%';
    }

    // Total records (without filters)
    $totalStmt = $pdo->query("SELECT COUNT(*) FROM course_master WHERE course_category = $categoryId AND is_block !=1");
    $recordsTotal = $totalStmt->fetchColumn();

    // Total filtered records
    $filterSql = "
        SELECT COUNT(*) 
        FROM course_master c
        LEFT JOIN category_master cm ON c.course_category = cm.category_id
        LEFT JOIN institute_master im ON c.institute_id = im.institute_id
        $searchQuery
    ";
    $filterStmt = $pdo->prepare($filterSql);
    $filterStmt->execute($params);
    $recordsFiltered = $filterStmt->fetchColumn();

    // Data query with filters, sorting, pagination
    $dataSql = "
        SELECT 
            c.*,
            c.expert_approval_status,
            c.expert_approval_comment,
            c.expert_approved_by,
            c.expert_approved_at,
            c.created_by,
            cm.category_name AS course_category,
            cm.category_id,
            im.institute_name,
            u.user_name AS expert_name
        FROM course_master c
        LEFT JOIN category_master cm ON c.course_category = cm.category_id
        LEFT JOIN institute_master im ON c.institute_id = im.institute_id
        LEFT JOIN user_master u ON c.expert_approved_by = u.user_id
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT :start, :length
    ";
    $stmt = $pdo->prepare($dataSql);
    foreach ($params as $key => $value) {
        $stmt->bindValue($key, $value);
    }
    $stmt->bindValue(':start', $start, PDO::PARAM_INT);
    $stmt->bindValue(':length', $length, PDO::PARAM_INT);
    $stmt->execute();
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($recordsTotal),
        'recordsFiltered' => intval($recordsFiltered),
        'data' => $data
    ]);
} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}