<?php
require_once('../includes/connection.php');
session_start(); // Ensure session is started

header('Content-Type: application/json');

// Check for required session and GET parameters
if (!isset($_SESSION['institute_id'])) {
    echo json_encode(['error' => 'Unauthorized access']);
    exit;
}

if (!isset($_GET['category_id'])) {
    echo json_encode(['error' => 'Missing category ID']);
    exit;
}

$institute_id = $_SESSION['institute_id'];
$category_id = $_GET['category_id']; // This should be the DECODED (not Base64) value if using encryption

try {
    $sql = "SELECT 
                c.course_id,
                c.course_name,
                cm.category_name AS course_category,
                c.level,
                c.description,
                c.image,
                c.created_date,
                c.created_by,
                c.institute_id,
                c.is_block,
                cm.category_id,
                im.institute_name
            FROM course_master c
            LEFT JOIN category_master cm ON c.course_category = cm.category_id
            LEFT JOIN institute_master im ON c.institute_id = im.institute_id
            WHERE c.institute_id = :institute_id AND cm.category_id = :category_id
            ORDER BY c.course_id DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':institute_id', $institute_id, PDO::PARAM_INT);
    $stmt->bindParam(':category_id', $category_id, PDO::PARAM_INT);
    $stmt->execute();

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($data);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database query failed: ' . $e->getMessage()]);
}
