<?php
require_once('../includes/connection.php'); // ensure $pdo is created
header('Content-Type: application/json');

$course_id = isset($_GET['course_id']) ? intval($_GET['course_id']) : null;

if (!$course_id) {
    echo json_encode(['error' => 'Missing or invalid course_id']);
    exit;
}

try {
    // Step 1: Get module IDs from course_module for this course
    $stmt = $pdo->prepare("SELECT module_id FROM course_module WHERE course_id = ?");
    $stmt->execute([$course_id]);
    $moduleIds = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($moduleIds)) {
        echo json_encode(['modules' => []]);
        exit;
    }

    // Step 2: Use those IDs to fetch module details from module_master
    $placeholders = rtrim(str_repeat('?,', count($moduleIds)), ',');
    $sql = "SELECT module_id AS id, module_name AS name 
            FROM module_master 
            WHERE is_block != 1 AND module_id IN ($placeholders)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($moduleIds);
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['modules' => $modules]);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database Error: ' . $e->getMessage()]);
}
?>