<?php
require_once('../includes/connection.php');
session_start();
header('Content-Type: application/json');

try {
    if (!isset($_SESSION['institute_id'])) {
        echo json_encode(['status' => 'error', 'message' => 'Institute not logged in']);
        exit;
    }

    $institute_id = $_SESSION['institute_id'];

    // Insert into course_draft
    $stmt = $pdo->prepare("INSERT INTO course_draft (institute_id) VALUES (:institute_id)");
    $stmt->bindParam(':institute_id', $institute_id);
    $stmt->execute();

    $newId = $pdo->lastInsertId();

    echo json_encode([
        'status' => 'success',
        'message' => 'Course draft created successfully',
        'course_draft_id' => $newId
    ]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>