<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if assignment_id is set
if (isset($data['assignment_id']) && !empty($data['assignment_id'])) {
    $questionId = (int)$data['assignment_id']; 
} else {
    echo json_encode(["status" => "error", "message" => "Assignment ID is required"]);
    exit();
}
 
try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE assignment_master SET is_deleted = '1' WHERE assignment_id= :assignment_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':assignment_id', $questionId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Assignment deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Assignment not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>