<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if category_id is set
if (isset($data['category_id']) && !empty($data['category_id'])) {
    $categoryId = (int)$data['category_id']; // Convert category_id to integer to prevent SQL injection
} else {
    echo json_encode(["status" => "error", "message" => "Institute ID is required"]);
    exit();
}

try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE category_master SET is_deleted = '1' WHERE category_id= :category_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':category_id', $categoryId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Category deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Category not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>