<?php
header('Content-Type: application/json');
require_once('../includes/connection.php'); // Adjust this path

$moduleId = isset($_POST['module_id']) ? intval($_POST['module_id']) : 0;

if (!$moduleId) {
    echo json_encode(['success' => false, 'message' => 'Invalid module_id']);
    exit;
}

try {
    // Start transaction
    $pdo->beginTransaction();

    // Delete from course_draft_modules
    $sqlDeleteDraftModules = "DELETE FROM course_draft_modules WHERE module_id = :module_id";
    $stmtDraft = $pdo->prepare($sqlDeleteDraftModules);
    $stmtDraft->execute([':module_id' => $moduleId]);

    // Delete from module_master
    $sqlDeleteModuleMaster = "DELETE FROM module_master WHERE module_id = :module_id";
    $stmtMaster = $pdo->prepare($sqlDeleteModuleMaster);
    $stmtMaster->execute([':module_id' => $moduleId]);

    // Commit transaction
    $pdo->commit();

    echo json_encode([
        'success' => true,
        'deleted_from_course_draft_modules' => $stmtDraft->rowCount(),
        'deleted_from_module_master' => $stmtMaster->rowCount()
    ]);
} catch (PDOException $e) {
    // Rollback on error
    $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
