<?php

// Crucial for debugging during development:
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Start output buffering to prevent "headers already sent" errors
ob_start();

header('Content-Type: application/json');

require_once('../includes/connection.php'); // Adjust path as needed
require('../vendor/autoload.php'); // For Vimeo API

use Vimeo\Vimeo;

// Vimeo credentials - ensure these are securely managed in production
define('VIMEO_CLIENT_ID', '5aa41d66ac6c8c8f7ac864af4455b38e58124df5');
define('VIMEO_CLIENT_SECRET', 'f9VSklt+8WdIEFjYZAR5Q+gdo6z+ZgJWPpcCeuQWsEpOG8ksBRHLJlnRgl0mJ6QyJv6Khcf5tiP4AplxYCpoeTlKisXZAUz5LombPknL7wTfpSmbdtupJGW/7OBM5');
define('VIMEO_ACCESS_TOKEN', '59049690f9eb19c23cd3aaa17a2c759e');

// --- Input Validation ---
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

$submoduleIdToDelete = isset($_POST['submodule_id']) ? intval($_POST['submodule_id']) : 0;
$draftId = isset($_POST['draft_id']) ? intval($_POST['draft_id']) : 0; // Assuming draft_id is passed for context/scope

if (!$submoduleIdToDelete) {
    http_response_code(400); // Bad Request
    echo json_encode(['success' => false, 'message' => 'Submodule ID missing or invalid.']);
    exit;
}

// --- Start Transaction ---
try {
    $pdo->beginTransaction();

    // 1. Fetch the submodule details, especially its associated study_material IDs
    $stmt = $pdo->prepare("SELECT study_material FROM submodule_master WHERE submodule_id = :submodule_id");
    $stmt->execute([':submodule_id' => $submoduleIdToDelete]);
    $submodule = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$submodule) {
        $pdo->rollBack();
        http_response_code(404); // Not Found
        echo json_encode(['success' => false, 'message' => 'Submodule not found.']);
        exit;
    }

    $studyMaterialCsv = $submodule['study_material'];
    $studyMaterialIds = array_map('intval', array_filter(explode(',', $studyMaterialCsv)));

    // 2. Delete associated study materials (records and files/Vimeo videos)
    $deletedStudyMaterialCount = 0;
    if (!empty($studyMaterialIds)) {
        // Fetch details of all study materials to be deleted
        $placeholders = implode(',', array_fill(0, count($studyMaterialIds), '?'));
        $stmtFetchMaterials = $pdo->prepare("SELECT study_material_id, actual_file_name, vimeo_link FROM study_material WHERE study_material_id IN ($placeholders)");
        $stmtFetchMaterials->execute($studyMaterialIds);
        $materialsToDelete = $stmtFetchMaterials->fetchAll(PDO::FETCH_ASSOC);

        $vimeoClient = null; // Initialize Vimeo client only if needed

        foreach ($materialsToDelete as $material) {
            // Delete local file if it exists
            if (!empty($material['actual_file_name'])) {
                $filePath = '../study/' . $material['actual_file_name'];
                if (file_exists($filePath)) {
                    if (!unlink($filePath)) {
                        error_log("Failed to delete local file: " . $filePath);
                        // Consider throwing an exception or just logging and continuing
                    }
                }
            }

            // Delete Vimeo video if link exists
            if (!empty($material['vimeo_link'])) {
                if ($vimeoClient === null) {
                    $vimeoClient = new Vimeo(VIMEO_CLIENT_ID, VIMEO_CLIENT_SECRET, VIMEO_ACCESS_TOKEN);
                }
                try {
                    // Vimeo API expects /videos/{video_id}
                    $response = $vimeoClient->request('/videos/' . $material['vimeo_link'], [], 'DELETE');
                    if ($response['status'] !== 204) { // 204 No Content is success for DELETE
                        error_log("Failed to delete Vimeo video ID " . $material['vimeo_link'] . ". Status: " . $response['status'] . " Body: " . json_encode($response['body']));
                    }
                } catch (Exception $vimeoEx) {
                    error_log("Vimeo API error deleting video ID " . $material['vimeo_link'] . ": " . $vimeoEx->getMessage());
                }
            }

            // Delete record from study_material table
            $stmtDeleteMaterial = $pdo->prepare("DELETE FROM study_material WHERE study_material_id = :study_material_id");
            $stmtDeleteMaterial->execute([':study_material_id' => $material['study_material_id']]);
            $deletedStudyMaterialCount += $stmtDeleteMaterial->rowCount();
        }
    }

    // 3. Update `course_draft_modules` entries to remove the submodule ID from CSV lists
    // We target entries for the specific draft_id if provided, otherwise all relevant entries.
    $sqlSelectCdm = "SELECT draft_module_id, sub_modules FROM course_draft_modules WHERE course_draft_id = :draft_id";
    $stmtSelectCdm = $pdo->prepare($sqlSelectCdm);
    $stmtSelectCdm->execute([':draft_id' => $draftId]);
    $cdmEntries = $stmtSelectCdm->fetchAll(PDO::FETCH_ASSOC);

    $updatedCdmCount = 0;
    foreach ($cdmEntries as $entry) {
        $currentSubmodules = $entry['sub_modules'];
        $submoduleArray = array_map('trim', array_filter(explode(',', $currentSubmodules)));

        // Remove the specific submodule ID from this array
        $updatedSubmoduleArray = array_filter($submoduleArray, function($id) use ($submoduleIdToDelete) {
            return (string)$id !== (string)$submoduleIdToDelete; // Compare as strings to be safe
        });

        $newSubmodulesCsv = implode(',', $updatedSubmoduleArray);

        // Only update if the list has actually changed
        if ($newSubmodulesCsv !== $currentSubmodules) {
            $sqlUpdateCdm = "UPDATE course_draft_modules SET sub_modules = :new_submodules WHERE draft_module_id = :draft_module_id";
            $stmtUpdateCdm = $pdo->prepare($sqlUpdateCdm);
            $stmtUpdateCdm->execute([
                ':new_submodules' => $newSubmodulesCsv,
                ':draft_module_id' => $entry['draft_module_id']
            ]);
            $updatedCdmCount += $stmtUpdateCdm->rowCount();
        }
    }

    // 4. Delete the submodule from `submodule_master`
    $stmtDeleteSubmodule = $pdo->prepare("DELETE FROM submodule_master WHERE submodule_id = :submodule_id");
    $stmtDeleteSubmodule->execute([':submodule_id' => $submoduleIdToDelete]);
    $deletedSubmoduleMasterCount = $stmtDeleteSubmodule->rowCount();

    // --- Commit Transaction ---
    $pdo->commit();

    http_response_code(200); // OK
    echo json_encode([
        'success' => true,
        'message' => 'Submodule and its associated content deleted successfully.',
        'submodule_id' => $submoduleIdToDelete,
        'deleted_study_materials_count' => $deletedStudyMaterialCount,
        'updated_course_draft_modules_count' => $updatedCdmCount,
        'deleted_submodule_master_count' => $deletedSubmoduleMasterCount
    ]);

} catch (PDOException $e) {
    $pdo->rollBack(); // Rollback on database error
    http_response_code(500); // Internal Server Error
    error_log("PDO Error in delete_draft_submodule_api.php: " . $e->getMessage() . " on line " . $e->getLine() . " in " . $e->getFile());
    echo json_encode(['success' => false, 'message' => 'A database error occurred during deletion. Please try again.']);
} catch (Exception $e) {
    $pdo->rollBack(); // Rollback on any other error
    http_response_code(500); // Internal Server Error
    error_log("General Error in delete_draft_submodule_api.php: " . $e->getMessage() . " on line " . $e->getLine() . " in " . $e->getFile());
    echo json_encode(['success' => false, 'message' => 'A server error occurred during deletion. Please try again.']);
}

// Ensure nothing else is outputted after the JSON
ob_end_flush();