<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Validate input data
if (!isset($data['faq_id']) || empty($data['faq_id'])) {
    echo json_encode(["status" => "error", "message" => "FAQ ID is required"]);
    exit();
}

$faqId = (int)$data['faq_id'];

try {
    // Update the `is_deleted` status instead of deleting
    $sql = "UPDATE faq_master SET is_deleted = 1 WHERE faq_id = :faq_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':faq_id', $faqId, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "FAQ deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "FAQ not found or already blocked"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}

?>
