<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if module_id is set
if (isset($data['module_id']) && !empty($data['module_id'])) {
    $moduleId = (int)$data['module_id']; // Convert module_id to integer to prevent SQL injection
} else {
    echo json_encode(["status" => "error", "message" => "Module ID is required"]);
    exit();
}

try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE module_master SET is_deleted = '1' WHERE module_id= :module_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':module_id', $moduleId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Module deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Module not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>