<?php

require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if student_id is set
if (isset($data['student_id']) && !empty($data['student_id'])) {
    $instituteId = (int)$data['student_id']; // Convert student_id to integer to prevent SQL injection
} else {
    echo json_encode(["status" => "error", "message" => "Student ID is required"]);
    exit();
}

try {
    // Prepare SQL to delete the category
    
    $sql = "UPDATE student_master SET is_deleted = '1' WHERE student_id= :student_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':student_id', $instituteId, PDO::PARAM_INT);
    $stmt->execute();

    // Check if the category was deleted
    if ($stmt->rowCount() > 0) {
        echo json_encode(["status" => "success", "message" => "Student deleted successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Student not found or could not be deleted"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>