<?php
// Start output buffering
if (ob_get_level() == 0) {
    ob_start();
}

// Start session if not started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
if (empty($_SESSION['user_id'])) {
    while (ob_get_level()) {
        ob_end_clean();
    }
    header("Location: ../logout.php");
    exit();
}

// Get filename from query parameter
if (!isset($_GET['file']) || empty($_GET['file'])) {
    while (ob_get_level()) {
        ob_end_clean();
    }
    header("HTTP/1.0 400 Bad Request");
    echo "File parameter is required.";
    exit();
}

$filename = basename($_GET['file']); // Prevent directory traversal
$filepath = __DIR__ . '/../error_reports/' . $filename;

// Check if file exists
if (!file_exists($filepath) || !is_file($filepath)) {
    while (ob_get_level()) {
        ob_end_clean();
    }
    header("HTTP/1.0 404 Not Found");
    echo "Error report file not found.";
    exit();
}

// Clear output buffers
while (ob_get_level()) {
    ob_end_clean();
}

// Set headers for file download
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . filesize($filepath));
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Pragma: public');
header('Expires: 0');

// Read and output the file
readfile($filepath);
exit();


