<?php
// Start output buffering immediately
if (ob_get_level() == 0) {
    ob_start();
}

// Start session if not started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
if (empty($_SESSION['user_id'])) {
    while (ob_get_level()) {
        ob_end_clean();
    }
    header("Location: ../logout.php");
    exit();
}

// Check for ZipArchive extension
if (!extension_loaded('zip')) {
    // Fallback to CSV
    while (ob_get_level()) {
        ob_end_clean();
    }
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="student_upload_template.csv"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Expires: 0');
    
    $output = fopen('php://output', 'w');
    fprintf($output, "\xEF\xBB\xBF"); // UTF-8 BOM
    $headers = ['Student Name', 'Email Address', 'Phone Number', 'Gender', 'Date of Birth', 'Institute Name'];
    fputcsv($output, $headers, ',', '"');
    $sampleData = ['John Doe', 'john.doe@example.com', '9876543210', 'male', '2000-01-15', 'Sample Institute'];
    fputcsv($output, $sampleData, ',', '"');
    fputcsv($output, [], ',', '"');
    fputcsv($output, ['Note:'], ',', '"');
    fputcsv($output, ['1. Remove the sample row (row 2) before uploading.'], ',', '"');
    fputcsv($output, ['2. Gender must be: male, female, or other'], ',', '"');
    fputcsv($output, ['3. Date of Birth format: YYYY-MM-DD (e.g., 2000-01-15)'], ',', '"');
    fputcsv($output, ['4. Phone Number must be exactly 10 digits'], ',', '"');
    fputcsv($output, ['5. Institute Name must match exactly with an existing institute in the system'], ',', '"');
    fclose($output);
    exit();
}

try {
    $tempFile = tempnam(sys_get_temp_dir(), 'excel_');
    $tempFile .= '.xlsx';
    
    $zip = new ZipArchive();
    if ($zip->open($tempFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== TRUE) {
        throw new Exception('Cannot create Excel file');
    }
    
    // [Content_Types].xml - Minimal
    $contentTypes = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types">
<Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml"/>
<Default Extension="xml" ContentType="application/xml"/>
<Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml"/>
<Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml"/>
<Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml"/>
</Types>';
    $zip->addFromString('[Content_Types].xml', $contentTypes);
    
    // _rels/.rels
    $rels = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">
<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument" Target="xl/workbook.xml"/>
</Relationships>';
    $zip->addFromString('_rels/.rels', $rels);
    
    // xl/workbook.xml - Minimal
    $workbook = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<workbook xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships">
<sheets>
<sheet name="Sheet1" sheetId="1" r:id="rId1"/>
</sheets>
</workbook>';
    $zip->addFromString('xl/workbook.xml', $workbook);
    
    // xl/_rels/workbook.xml.rels
    $workbookRels = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">
<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet" Target="worksheets/sheet1.xml"/>
<Relationship Id="rId2" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles" Target="styles.xml"/>
</Relationships>';
    $zip->addFromString('xl/_rels/workbook.xml.rels', $workbookRels);
    
    // xl/styles.xml - Minimal but complete
    $styles = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<styleSheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main">
<numFmts count="0"/>
<fonts count="2">
<font><sz val="11"/><color theme="1"/><name val="Calibri"/><family val="2"/><scheme val="minor"/></font>
<font><b/><sz val="12"/><color rgb="FF000000"/><name val="Calibri"/><family val="2"/></font>
</fonts>
<fills count="2">
<fill><patternFill patternType="none"/></fill>
<fill><patternFill patternType="solid"><fgColor rgb="FFE6D9F5"/></patternFill></fill>
</fills>
<borders count="1">
<border><left/><right/><top/><bottom/><diagonal/></border>
</borders>
<cellStyleXfs count="1">
<xf numFmtId="0" fontId="0" fillId="0" borderId="0"/>
</cellStyleXfs>
<cellXfs count="2">
<xf numFmtId="0" fontId="0" fillId="0" borderId="0" xfId="0"/>
<xf numFmtId="0" fontId="1" fillId="1" borderId="0" xfId="0" applyFont="1" applyFill="1" applyAlignment="1" applyBorder="0"><alignment horizontal="center" vertical="center"/></xf>
</cellXfs>
<cellStyles count="1">
<cellStyle name="Normal" xfId="0" builtinId="0"/>
</cellStyles>
<dxfs count="0"/>
<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4"/>
</styleSheet>';
    $zip->addFromString('xl/styles.xml', $styles);
    
    // xl/worksheets/sheet1.xml - Minimal but complete
    $sheetData = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships">
<dimension ref="A1:F9"/>
<sheetViews>
<sheetView tabSelected="1" workbookViewId="0" showGridLines="1">
<pane ySplit="1" topLeftCell="A2" activePane="bottomLeft" state="frozen"/>
<selection pane="bottomLeft" activeCell="A2" sqref="A2"/>
</sheetView>
</sheetViews>
<sheetFormatPr baseColWidth="10" defaultRowHeight="15"/>
<cols>
<col min="1" max="1" width="25" customWidth="1"/>
<col min="2" max="2" width="30" customWidth="1"/>
<col min="3" max="3" width="15" customWidth="1"/>
<col min="4" max="4" width="12" customWidth="1"/>
<col min="5" max="5" width="15" customWidth="1"/>
<col min="6" max="6" width="15" customWidth="1"/>
</cols>
<sheetData>
<row r="1" spans="1:6" ht="20" customHeight="1">
<c r="A1" t="inlineStr" s="1"><is><t>Student Name</t></is></c>
<c r="B1" t="inlineStr" s="1"><is><t>Email Address</t></is></c>
<c r="C1" t="inlineStr" s="1"><is><t>Phone Number</t></is></c>
<c r="D1" t="inlineStr" s="1"><is><t>Gender</t></is></c>
<c r="E1" t="inlineStr" s="1"><is><t>Date of Birth</t></is></c>
<c r="F1" t="inlineStr" s="1"><is><t>Institute Name</t></is></c>
</row>
<row r="2" spans="1:6">
<c r="A2" t="inlineStr"><is><t>John Doe</t></is></c>
<c r="B2" t="inlineStr"><is><t>john.doe@example.com</t></is></c>
<c r="C2" t="inlineStr"><is><t>9876543210</t></is></c>
<c r="D2" t="inlineStr"><is><t>male</t></is></c>
<c r="E2" t="inlineStr"><is><t>2000-01-15</t></is></c>
<c r="F2" t="inlineStr"><is><t>Sample Institute</t></is></c>
</row>
<row r="4" spans="1:1">
<c r="A4" t="inlineStr"><is><t>Note:</t></is></c>
</row>
<row r="5" spans="1:1">
<c r="A5" t="inlineStr"><is><t>1. Remove the sample row (row 2) before uploading.</t></is></c>
</row>
<row r="6" spans="1:1">
<c r="A6" t="inlineStr"><is><t>2. Gender must be: male, female, or other</t></is></c>
</row>
<row r="7" spans="1:1">
<c r="A7" t="inlineStr"><is><t>3. Date of Birth format: YYYY-MM-DD (e.g., 2000-01-15)</t></is></c>
</row>
<row r="8" spans="1:1">
<c r="A8" t="inlineStr"><is><t>4. Phone Number must be exactly 10 digits</t></is></c>
</row>
<row r="9" spans="1:1">
<c r="A9" t="inlineStr"><is><t>5. Institute Name must match exactly with an existing institute in the system</t></is></c>
</row>
</sheetData>
<pageMargins left="0.7" right="0.7" top="0.75" bottom="0.75" header="0.3" footer="0.3"/>
</worksheet>';
    $zip->addFromString('xl/worksheets/sheet1.xml', $sheetData);
    
    $zip->close();
    
    if (!file_exists($tempFile) || filesize($tempFile) == 0) {
        throw new Exception('Failed to generate Excel file');
    }
    
    // Clear ALL output buffers
    while (ob_get_level()) {
        ob_end_clean();
    }
    
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="student_upload_template.xlsx"');
    header('Content-Length: ' . filesize($tempFile));
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Expires: 0');
    
    readfile($tempFile);
    @unlink($tempFile);
    exit();
    
} catch (Exception $e) {
    error_log("Excel Template Error: " . $e->getMessage());
    
    while (ob_get_level()) {
        ob_end_clean();
    }
    
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="student_upload_template.csv"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Expires: 0');
    
    $output = fopen('php://output', 'w');
    fprintf($output, "\xEF\xBB\xBF");
    $headers = ['Student Name', 'Email Address', 'Phone Number', 'Gender', 'Date of Birth', 'Institute Name'];
    fputcsv($output, $headers, ',', '"');
    $sampleData = ['John Doe', 'john.doe@example.com', '9876543210', 'male', '2000-01-15', 'Sample Institute'];
    fputcsv($output, $sampleData, ',', '"');
    fputcsv($output, [], ',', '"');
    fputcsv($output, ['Note:'], ',', '"');
    fputcsv($output, ['1. Remove the sample row (row 2) before uploading.'], ',', '"');
    fputcsv($output, ['2. Gender must be: male, female, or other'], ',', '"');
    fputcsv($output, ['3. Date of Birth format: YYYY-MM-DD (e.g., 2000-01-15)'], ',', '"');
    fputcsv($output, ['4. Phone Number must be exactly 10 digits'], ',', '"');
    fputcsv($output, ['5. Institute Name must match exactly with an existing institute in the system'], ',', '"');
    fclose($output);
    exit();
}
