<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if category_name and category_id are set
if (isset($data['category_name']) && !empty($data['category_name']) && isset($data['category_id'])) {
    $categoryName = trim($data['category_name']);
    $status = ($data['status']);
    $categoryId = base64_decode($data['category_id']);
} else {
    echo json_encode(["status" => "error", "message" => "Category name and ID are required"]);
    exit();
}

try {
    $institute_id = $_SESSION['institute_id'];
    
    // Prepare SQL query to check if the category already exists (excluding the current category)
    $checkSql = "SELECT COUNT(*) FROM category_master WHERE category_name = :category_name AND category_id != :category_id AND institute_id = :institute_id";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->bindParam(':category_name', $categoryName);
    $checkStmt->bindParam(':category_id', $categoryId);
    $checkStmt->bindParam(':institute_id', $institute_id);
    $checkStmt->execute();
    $count = $checkStmt->fetchColumn();

    if ($count > 0) {
        // If the category already exists, show an error message
        echo json_encode(["status" => "error", "message" => "Category already exists."]);
        exit();
    }

    // Update the category if it doesn't exist
    $sql = "UPDATE category_master SET category_name = :category_name, is_block = :status WHERE category_id = :category_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':category_name', $categoryName);
    $stmt->bindParam(':category_id', $categoryId);
    $stmt->bindParam(':status', $status);
    $stmt->execute();

    // Respond with a success message
    echo json_encode(["status" => "success", "message" => "Category updated successfully!"]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}

?>
