<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['faq_question']) && !empty($data['faq_question']) && isset($data['faq_id'])) {

    $faqId = trim($data['faq_id']);
    $faqQuestion = trim($data['faq_question']);
    $faqAnswer = trim($data['faq_answer']);
    $faqBlock = trim($data['faq_block']);

} else {
    echo json_encode(["status" => "error", "message" => "All fields are required."]);
    exit();
}

try {
    $sql = "UPDATE faq_master SET faq_question = :faq_question, faq_answer = :faq_answer, is_block = :faq_block WHERE faq_id = :faq_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':faq_question', $faqQuestion);
    $stmt->bindParam(':faq_answer', $faqAnswer);
    $stmt->bindParam(':faq_block', $faqBlock);
    $stmt->bindParam(':faq_id', $faqId);

    $stmt->execute();
    echo json_encode(["status" => "success", "message" => "FAQ updated successfully!"]);

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
