<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if (isset($_POST['mentor_name']) && !empty($_POST['mentor_name'])) {

    $mentorName       = trim($_POST['mentor_name']);
    $phone_no         = $_POST['phone_no'] ?? '';
    $email_id         = $_POST['email_id'] ?? '';
    $password         = $_POST['password'] ?? '';
    $encoded_password = base64_encode($password);
    $specialization   = $_POST['specialization'] ?? '';
    $linkedin_profile = $_POST['linkedin_profile'] ?? '';
    $block_mentor     = $_POST['block_mentor'] ?? '0';
    $industry_expert  = $_POST['industry_expert'] ?? '0';
    $mentorId         = base64_decode($_POST['mentor_id']);

    // Decide category
    $category = ($industry_expert == '1') ? 'expert' : 'mentor';

    try {
        $user_id      = $_SESSION['user_id'];
        $institute_id = $_SESSION['institute_id'];

        /* ================= DUPLICATE CHECKS ================= */

        $stmt = $pdo->prepare(
            "SELECT COUNT(*) FROM mentor_master 
             WHERE email_id = :email_id AND mentor_id != :mentor_id"
        );
        $stmt->execute([
            ':email_id'  => $email_id,
            ':mentor_id' => $mentorId
        ]);
        if ($stmt->fetchColumn() > 0) {
            echo json_encode(["status" => "error", "message" => "Email ID already exists."]);
            exit;
        }

        $stmt = $pdo->prepare(
            "SELECT COUNT(*) FROM mentor_master 
             WHERE phone_no = :phone_no AND mentor_id != :mentor_id"
        );
        $stmt->execute([
            ':phone_no'  => $phone_no,
            ':mentor_id' => $mentorId
        ]);
        if ($stmt->fetchColumn() > 0) {
            echo json_encode(["status" => "error", "message" => "Phone number already exists."]);
            exit;
        }

        /* ================= FETCH USER ID ================= */

        $stmt = $pdo->prepare("SELECT user_id FROM mentor_master WHERE mentor_id = :mentor_id");
        $stmt->execute([':mentor_id' => $mentorId]);
        $mentorUserId = $stmt->fetchColumn();

        if (!$mentorUserId) {
            throw new Exception("Linked user not found.");
        }

        /* ================= UPDATE USER MASTER ================= */

        $updateUserSql = "UPDATE user_master SET
                user_name = :user_name,
                email_id  = :email_id,
                password = :password,
                phone_no  = :phone_no,
                category  = :category,
                is_block  = :is_block
            WHERE user_id = :user_id";

        $pdo->prepare($updateUserSql)->execute([
            ':user_name' => $mentorName,
            ':email_id'  => $email_id,
            ':password'  => $encoded_password,
            ':phone_no'  => $phone_no,
            ':category'  => $category,
            ':is_block'  => $block_mentor,
            ':user_id'   => $mentorUserId
        ]);

        /* ================= FILE HANDLING ================= */

        $stmt = $pdo->prepare(
            "SELECT folder_name FROM institute_master WHERE institute_id = :institute_id"
        );
        $stmt->execute([':institute_id' => $institute_id]);
        $folderName = $stmt->fetchColumn();

        if (!$folderName) {
            throw new Exception("Institute folder not found.");
        }

        $uploadDir = "../institutes/{$folderName}/mentor_images/";

        $stmt = $pdo->prepare("SELECT photo, cv FROM mentor_master WHERE mentor_id = :mentor_id");
        $stmt->execute([':mentor_id' => $mentorId]);
        $mentor = $stmt->fetch(PDO::FETCH_ASSOC);

        $mentorImgPath = $mentor['photo'] ?? '';
        $mentorCVPath  = $mentor['cv'] ?? '';

        if (isset($_FILES['mentor_img']) && $_FILES['mentor_img']['error'] === UPLOAD_ERR_OK) {
            if (!empty($mentorImgPath) && file_exists($uploadDir . $mentorImgPath)) {
                unlink($uploadDir . $mentorImgPath);
            }
            $ext = strtolower(pathinfo($_FILES['mentor_img']['name'], PATHINFO_EXTENSION));
            $mentorImgPath = hash('sha256', uniqid()) . '.' . $ext;
            move_uploaded_file($_FILES['mentor_img']['tmp_name'], $uploadDir . $mentorImgPath);
        }

        if (isset($_FILES['mentor_cv']) && $_FILES['mentor_cv']['error'] === UPLOAD_ERR_OK) {
            if (!empty($mentorCVPath) && file_exists($uploadDir . $mentorCVPath)) {
                unlink($uploadDir . $mentorCVPath);
            }
            $ext = strtolower(pathinfo($_FILES['mentor_cv']['name'], PATHINFO_EXTENSION));
            $mentorCVPath = hash('sha256', uniqid()) . '.' . $ext;
            move_uploaded_file($_FILES['mentor_cv']['tmp_name'], $uploadDir . $mentorCVPath);
        }

        /* ================= UPDATE MENTOR MASTER ================= */

        $updateSql = "UPDATE mentor_master SET
            mentor_name = :mentor_name,
            phone_no = :phone_no,
            email_id = :email_id,
            specialization = :specialization,
            linkedin_profile = :linkedin_profile,
            is_block = :block_mentor,
            industry_expert = :industry_expert,
            photo = :mentor_img,
            cv = :mentor_cv";

        if (!empty($password)) {
            $updateSql .= ", password = :password";
        }

        $updateSql .= " WHERE mentor_id = :mentor_id";

        $params = [
            ':mentor_name'     => $mentorName,
            ':phone_no'        => $phone_no,
            ':email_id'        => $email_id,
            ':specialization'  => $specialization,
            ':linkedin_profile'=> $linkedin_profile,
            ':block_mentor'    => $block_mentor,
            ':industry_expert' => $industry_expert,
            ':mentor_img'      => $mentorImgPath,
            ':mentor_cv'       => $mentorCVPath,
            ':mentor_id'       => $mentorId
        ];

        if (!empty($password)) {
            $params[':password'] = base64_encode($password);
        }

        $pdo->prepare($updateSql)->execute($params);

        echo json_encode([
            "status" => "success",
            "message" => "Mentor updated successfully!"
        ]);

    } catch (Exception $e) {
        echo json_encode([
            "status" => "error",
            "message" => "Error: " . $e->getMessage()
        ]);
    }

} else {
    echo json_encode([
        "status" => "error",
        "message" => "Mentor name is required."
    ]);
}
?>