<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['module_name']) && !empty($data['module_name']) && isset($data['module_id'])) {
    $moduleName = trim($data['module_name']);
    $moduleId = base64_decode($data['module_id']);
    $description = isset($data['description']) ? $data['description'] : '';
    $is_block = isset($data['status']) ? $data['status'] : '';
} else {
    echo json_encode(["status" => "error", "message" => "Module name and ID are required"]);
    exit();
}

try {
    $institute_id = $_SESSION['institute_id'];
    
    // Prepare SQL query to check if the submodule already exists (excluding the current category)
    $checkSql = "SELECT COUNT(*) FROM module_master WHERE module_name = :module_name AND module_id != :module_id AND institute_id = :institute_id";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->bindParam(':module_name', $moduleName);
    $checkStmt->bindParam(':module_id', $moduleId);
    $checkStmt->bindParam(':institute_id', $institute_id);
    $checkStmt->execute();
    $count = $checkStmt->fetchColumn();

    if ($count > 0) {
        echo json_encode(["status" => "error", "message" => "Module already exists."]);
        exit();
    }

    // Update the submodule if it doesn't exist
    $sql = "UPDATE module_master SET module_name = :module_name, description = :description, is_block = :is_block  WHERE module_id = :module_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':module_name', $moduleName);
    $stmt->bindParam(':module_id', $moduleId);
    $stmt->bindParam(':description', $description);
    $stmt->bindParam(':is_block', $is_block);
    $stmt->execute();

    // Respond with a success message
    echo json_encode(["status" => "success", "message" => "Module updated successfully!"]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}

?>
