<?php
require_once('../includes/connection.php');
require_once('../cr/vimeo_upload_question.php');
header('Content-Type: application/json');

use Vimeo\Vimeo;

$clientId = "33aca9a43d56881867d184a6fd6812214c859d7f";
$clientSecret = "RxhsebeBUpDtexh1NEy/wtvc6nygztKCQuLdumBH9brJxhYccpNdUDs2dbrBJgi8ERWF+5ey2jShRKRt5+zboo9Euza+5XIkgfnKhBSPEk0o9dT4W8FEZmUuKEl6td4b";
$accessToken = "75e5b3cf9fecae07f07f254889398e20";

$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

try {
    $questionId        = base64_decode($_POST['question_id']);
    $categoryCourseId  = trim($_POST['category']);
    $type              = trim($_POST['type']);
    $criteria          = trim($_POST['criteria']);
    $level             = trim($_POST['level']);
    $mediaType         = trim($_POST['media_select']);
    $question          = trim($_POST['question']);
    $videoMode         = trim($_POST['video_mode'] ?? '');
    $videoUrlInput     = trim($_POST['video_url'] ?? '');
    $videoTitle        = trim($_POST['video_title'] ?? '');
    $marks             = trim($_POST['marks']);
    $duration          = trim($_POST['duration']);
    $createdBy         = trim($_POST['created_by']);
    $instituteId       = trim($_POST['institute_id']);


if ($mediaType === 'Video' && $videoMode === 'vimeo' && empty($videoTitle)) {
    echo json_encode([
        "status" => "error",
        "message" => "Title for video is missing"
    ]);
    exit();
}


if ($criteria === 'quiz') {
    $marks = '';
    $duration = '';
}

    // -----------------------------
    // DUPLICATION CHECK
    // -----------------------------
    $dupCheck = $pdo->prepare("SELECT COUNT(*) FROM question_master 
        WHERE question = :question AND category_course_id = :category 
        AND institute_id = :institute_id AND question_master_id != :qid");
    $dupCheck->execute([
        ':question' => $question,
        ':category' => $categoryCourseId,
        ':institute_id' => $instituteId,
        ':qid' => $questionId
    ]);
    if ($dupCheck->fetchColumn() > 0) {
        echo json_encode(["status" => "error","message" => "Question already exists in this category."]);
        exit();
    }

    // -----------------------------
    // OPTIONS
    // -----------------------------
    if ($type === "true_false" || $type === "yes_no") {
        $option1 = $option2 = $option3 = $option4 = null;
    } else {
        $option1 = trim($_POST['option_1'] ?? '');
        $option2 = trim($_POST['option_2'] ?? '');
        $option3 = trim($_POST['option_3'] ?? '');
        $option4 = trim($_POST['option_4'] ?? '');
    }

    // -----------------------------
    // CORRECT ANSWER
    // -----------------------------
if ($type === "multiple_answers" && isset($_POST['multiple_options']) && is_array($_POST['multiple_options'])) {
    $correctAnswer = implode(",", array_map('trim', $_POST['multiple_options']));
} else {
    $correctAnswer = trim($_POST['correct_answer'] ?? '');
}



    // -----------------------------
    // FETCH OLD MEDIA
    // -----------------------------
    $stmtOld = $pdo->prepare("SELECT video_url, video_type, image_url FROM question_master WHERE question_master_id = :id");
    $stmtOld->execute([':id'=>$questionId]);
    $old = $stmtOld->fetch(PDO::FETCH_ASSOC);

    $videoUrl  = $old['video_url'] ?? null;
    $videoType = $old['video_type'] ?? null;
    $imageUrl  = $old['image_url'] ?? null;

    // =====================================================
    // MAIN MEDIA SWITCH
    // =====================================================
    if ($mediaType === "Text") {
        // Just clear both video and image
        $videoUrl = null;
        $videoType = null;
        $videoTitle = null;
        $imageUrl = null;

    } elseif ($mediaType === "Image") {
        if (isset($_FILES['image_upload']) && $_FILES['image_upload']['error'] == UPLOAD_ERR_OK) {
            $file = $_FILES['image_upload'];
            $allowedExts = ['pdf','jpg','jpeg','png','ppt','pptx','txt'];
            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            if (!in_array($ext, $allowedExts)) {
                echo json_encode(['status'=>'error','message'=>'Unsupported image type']);
                exit;
            }

            // get institute folder
            $stmt = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :id");
            $stmt->execute([':id'=>$institute_id]);
            $folder = $stmt->fetchColumn();
            if (!$folder) throw new Exception("Institute folder not found.");

            $uploadDir = "../institutes/$folder/question_images/";
            if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

            // ✅ Delete old image if exists
            if (!empty($old['image_url'])) {
                $oldImagePath = $uploadDir . $old['image_url'];
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }

            // Upload new
            $newName = bin2hex(random_bytes(16)) . '.' . $ext;
            $target = $uploadDir . $newName;

            if (!move_uploaded_file($file['tmp_name'], $target)) {
                throw new Exception("Image upload failed");
            }

            $imageUrl = $newName;
        }
        // clear any old video
        $videoUrl = null;
        $videoType = null;
        $videoTitle = null;

    } elseif ($mediaType === "Video") {
        if ($videoMode === "Youtube" && !empty($videoUrlInput)) {
            $videoUrl = $videoUrlInput;
            $videoType = 'Youtube';
            $videoTitle = '';

        } elseif ($videoMode === "vimeo") {

    // Check if a new video file is uploaded
    if (!empty($_FILES['video_upload']['name']) && $_FILES['video_upload']['error'] == UPLOAD_ERR_OK) {

        // If old video exists, delete it via your delete_vimeo_video.php
        if ($videoType === 'vimeo' && !empty($videoUrl)) {

    preg_match('/vimeo\.com\/(\d+)/', $videoUrl, $matches);
    $vimeoVideoId = $matches[1] ?? '';
    
                // Delete from Vimeo
                $client = new Vimeo($clientId, $clientSecret, $accessToken);
                try {
                    $response = $client->request("/videos/{$vimeoVideoId}", [], 'DELETE');
            
                    if ($response['status'] === 204) {
                        $deleteFromDB = true;
                    } else {
                        echo json_encode(['success' => false, 'message' => 'Failed to delete from Vimeo']);
                        exit;
                    }
                } catch (Exception $e) {
                    echo json_encode(['success' => false, 'message' => 'Vimeo error: ' . $e->getMessage()]);
                    exit;
                }
        }

        // Upload new video
        $uploadResult = uploadStudyMaterial($_FILES['video_upload'], $question, '');
        if (!$uploadResult || !$uploadResult['success']) {
            echo json_encode([
                'status' => 'error',
                'message' => $uploadResult['message'] ?? 'Vimeo upload failed'
            ]);
            exit;
        }

        // Update video fields
        $videoUrl  = $uploadResult['video_link'];
        $videoType = 'vimeo';
        $videoTitle = $videoTitle ?? ''; // optional title
    }
    // If no new file uploaded, keep old $videoUrl, $videoType, $videoTitle
}


        // clear image
        $imageUrl = null;
    }
    // =====================================================

    // -----------------------------
    // FINAL UPDATE
    // -----------------------------
    $stmt = $pdo->prepare("UPDATE question_master 
        SET category_course_id=:cat,type=:type,criteria=:criteria,level=:level,
            media=:media,question=:question,
            video_type=:vtype,video_url=:vurl,video_title=:vtitle,image_url=:image,
            option_1=:op1,option_2=:op2,option_3=:op3,option_4=:op4,
            correct_answer=:correct,marks=:marks,duration=:duration,
            created_by=:created,institute_id=:inst
        WHERE question_master_id=:id");
    $stmt->execute([
        ':cat'=>$categoryCourseId, ':type'=>$type, ':criteria'=>$criteria, ':level'=>$level,
        ':media'=>$mediaType, ':question'=>$question,
        ':vtype'=>$videoType, ':vurl'=>$videoUrl, ':vtitle'=>$videoTitle, ':image'=>$imageUrl,
        ':op1'=>$option1, ':op2'=>$option2, ':op3'=>$option3, ':op4'=>$option4,
        ':correct'=>$correctAnswer, ':marks'=>$marks, ':duration'=>$duration,
        ':created'=>$createdBy, ':inst'=>$instituteId, ':id'=>$questionId
    ]);

    echo json_encode(["status"=>"success","message"=>"Question updated successfully"]);

} catch (Exception $e) {
    echo json_encode(["status"=>"error","message"=>"Error: ".$e->getMessage()]);
}
?>