<?php
require_once('../includes/connection.php');
require_once('emailer.php');
header('Content-Type: application/json');

// Validate required fields
if (
    isset($_POST['student_id']) && !empty($_POST['student_id']) &&
    isset($_POST['email_address']) && !empty($_POST['email_address']) &&
    isset($_POST['phone_number']) && !empty($_POST['phone_number']) &&
    isset($_POST['studentname']) && !empty($_POST['studentname']) &&
    isset($_POST['gender']) && !empty($_POST['gender']) &&
    isset($_POST['institute_id']) && !empty($_POST['institute_id'])
) {
    $student_id = base64_decode($_POST['student_id']);
    $email = trim($_POST['email_address']);
    $phone = trim($_POST['phone_number']);
    $student_name = trim($_POST['studentname']);
    $gender = trim($_POST['gender']);
    $dob = isset($_POST['date_of_birth']) ? trim($_POST['date_of_birth']) : '';
    $institute_id = $_POST['institute_id'];
} else {
    echo json_encode(["status" => "error", "message" => "All required fields must be filled."]);
    exit();
}

try {
    // Fetch old data
    $stmtOld = $pdo->prepare("SELECT email_id, password, user_id FROM student_master WHERE student_id = :id");
    $stmtOld->execute([':id' => $student_id]);
    $oldStudent = $stmtOld->fetch(PDO::FETCH_ASSOC);

    if (!$oldStudent) {
        echo json_encode(["status" => "error", "message" => "Student not found."]);
        exit();
    }


// Check for existing email (exclude current user)
$stmtEmail = $pdo->prepare("SELECT COUNT(*) FROM user_master WHERE email_id = :email AND user_id != :user_id");
$stmtEmail->execute([':email' => $email, ':user_id' => $oldStudent['user_id']]);
if ($stmtEmail->fetchColumn() > 0) {
    echo json_encode(["status" => "error", "message" => "Email already exists."]);
    exit();
}

// Check for existing phone number (exclude current user)
$stmtPhone = $pdo->prepare("SELECT COUNT(*) FROM user_master WHERE phone_no = :phone AND user_id != :user_id");
$stmtPhone->execute([':phone' => $phone, ':user_id' => $oldStudent['user_id']]);
if ($stmtPhone->fetchColumn() > 0) {
    echo json_encode(["status" => "error", "message" => "Phone number already exists."]);
    exit();
}

    
    $emailChanged = strtolower($oldStudent['email_id']) !== strtolower($email);
    $user_id = $oldStudent['user_id'];
    $encodedPassword = $oldStudent['password'];
    $decodedPassword = base64_decode($encodedPassword);

    // Update user_master
    $stmtUser = $pdo->prepare("
        UPDATE user_master 
        SET email_id = :email, phone_no = :phone, user_name = :name, institute_id = :institute_id
        WHERE user_id = :user_id
    ");
    $stmtUser->execute([
        ':email' => $email,
        ':phone' => $phone,
        ':name' => $student_name,
        ':institute_id' => $institute_id,
        ':user_id' => $user_id        
    ]);

    // Update student_master
    $stmtStudent = $pdo->prepare("
        UPDATE student_master 
        SET student_name = :name, email_id = :email, phone_no = :phone, dob = :dob, gender = :gender, institute_id = :institute_id 
        WHERE student_id = :student_id
    ");
    $stmtStudent->execute([
        ':name' => $student_name,
        ':email' => $email,
        ':phone' => $phone,
        ':dob' => $dob,
        ':gender' => $gender,
        ':institute_id' => $institute_id,        
        ':student_id' => $student_id
    ]);

    // Conditionally send email if email has changed
    if ($emailChanged) {
        $emailSent = sendStudentWelcomeEmail($email, $student_name, $decodedPassword);

        if ($emailSent) {
            echo json_encode([
                "status" => "success",
                "message" => "Student details updated. Login credentials have been sent to the new email address."
            ]);
        } else {
            echo json_encode([
                "status" => "warning",
                "message" => "Student details updated. but we were unable to send the login credentials via email."
            ]);
        }
    } else {
        echo json_encode([
            "status" => "success",
            "message" => "Student details updated successfully."
        ]);
    }

} catch (PDOException $e) {
    error_log("DB Error: " . $e->getMessage());
    echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
}
?>