<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

// Receive the input data from the POST request
$data = json_decode(file_get_contents("php://input"), true);

// Check if submodule_name and submodule_id are set
if (isset($data['submodule_name']) && !empty($data['submodule_name']) && isset($data['submodule_id'])) {
    $submoduleName = trim($data['submodule_name']);
    $submoduleId = base64_decode($data['submodule_id']);
    $description = trim($data['description']);
    $moduleId = trim($data['module_id']);
} else {
    echo json_encode(["status" => "error", "message" => "Submodule name and ID are required"]);
    exit();
}

try {
    // Prepare SQL query to check if the submodule already exists (excluding the current category)
    $checkSql = "SELECT COUNT(*) FROM submodule_master WHERE submodule_name = :submodule_name AND submodule_id != :submodule_id";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->bindParam(':submodule_name', $submoduleName);
    $checkStmt->bindParam(':submodule_id', $submoduleId);
    $checkStmt->execute();
    $count = $checkStmt->fetchColumn();

    if ($count > 0) {
        // If the submodule already exists, show an error message
        echo json_encode(["status" => "error", "message" => "Submodule already exists."]);
        exit();
    }

    // Update the submodule if it doesn't exist
    $sql = "UPDATE submodule_master SET submodule_name = :submodule_name, description = :description, module_id = :module_id  WHERE submodule_id = :submodule_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':submodule_name', $submoduleName);
    $stmt->bindParam(':submodule_id', $submoduleId);
    $stmt->bindParam(':module_id', $moduleId);
    $stmt->bindParam(':description', $description);
    $stmt->execute();

    // Respond with a success message
    echo json_encode(["status" => "success", "message" => "Submodule updated successfully!"]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}

?>
