<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'employee_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');

    $allowedSortFields = ['employee_id','first_name', 'phone_no', 'email_id', 'is_block'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'employee_id';
    }

    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    $searchQuery = "WHERE is_deleted != 1";
    $searchParams = [];

    if (!empty($searchValue)) {
        $searchLike = "%$searchValue%";
        $searchQuery .= " AND (first_name LIKE ? OR phone_no LIKE ? OR email_id LIKE ?";
        $searchParams = [$searchLike, $searchLike, $searchLike];

        if (stripos($searchValue, 'inactive') !== false) {
            $searchQuery .= " OR is_block = ?";
            $searchParams[] = '1';
        } elseif (stripos($searchValue, 'active') !== false) {
            $searchQuery .= " OR is_block = ?";
            $searchParams[] = '0';
        }

        $searchQuery .= ")";
    }

    // Total records count
    $totalRecords = $pdo->query("SELECT COUNT(*) FROM employee_master WHERE is_deleted != 1")->fetchColumn();

    // Filtered records count
    if (!empty($searchParams)) {
        $filteredStmt = $pdo->prepare("SELECT COUNT(*) FROM employee_master $searchQuery");
        $filteredStmt->execute($searchParams);
        $filteredRecords = $filteredStmt->fetchColumn();
    } else {
        $filteredRecords = $totalRecords;
    }

    // Fetch paginated data
    $dataSql = "
        SELECT employee_id, first_name, last_name, phone_no, email_id, is_block
        FROM employee_master
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $dataStmt = $pdo->prepare($dataSql);
    $finalParams = array_merge($searchParams, [$start, $length]);
    $dataStmt->execute($finalParams);
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);
} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}