<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$institute_id = $_SESSION['institute_id'];

try {
    $stmt = $pdo->prepare("
        SELECT mentor_id AS id, mentor_name AS name 
        FROM mentor_master 
        WHERE is_block != 1 AND industry_expert = 1 AND is_deleted != 1 AND institute_id = :institute_id
    ");
    $stmt->execute([':institute_id' => $institute_id]);
    $mentors = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['mentors' => $mentors]); // This is what your JS expects
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database Error: ' . $e->getMessage()]);
}
?>