<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

if (!isset($_GET['id']) || empty($_GET['id'])) {
    http_response_code(400);
    echo json_encode(["error" => "Missing course ID"]);
    exit;
}

$course_id = intval($_GET['id']);
$institute_id = $_SESSION['institute_id'] ?? 0;

// Get institute folder name
$stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
$stmtFolder->execute([':institute_id' => $institute_id]);
$currentFolder = $stmtFolder->fetchColumn();
if (!$currentFolder) {
    echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
    exit;
}

// Get superadmin folder
$stmtSuperFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = 1");
$stmtSuperFolder->execute();
$superadminFolder = $stmtSuperFolder->fetchColumn();

try {
    // Step 1: Get module_ids for the course
    $stmt = $pdo->prepare("SELECT module_id FROM course_module WHERE course_id = ? ORDER BY sequence ASC");
    $stmt->execute([$course_id]);
    $module_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);

    $result = [];

    foreach ($module_ids as $module_id) {
        // Module details
        $stmt = $pdo->prepare("SELECT module_name, study_material FROM module_master WHERE module_id = ?");
        $stmt->execute([$module_id]);
        $module = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$module) continue;

        // Module-level contents
        $module_study_ids = array_filter(array_map('trim', explode(',', $module['study_material'])));
        $module_contents = [];

        if (!empty($module_study_ids)) {
            $placeholders = implode(',', array_fill(0, count($module_study_ids), '?'));
            $stmtMat = $pdo->prepare("SELECT * FROM study_material WHERE study_material_id IN ($placeholders)");
            $stmtMat->execute($module_study_ids);
            $materials = $stmtMat->fetchAll(PDO::FETCH_ASSOC);

            foreach ($materials as $mat) {
                $doc_type = strtolower($mat['doc_type']);
                if ($doc_type === 'video') {
                    $src = $mat['vimeo_link'];
                    if (preg_match('/https:\/\/vimeo\.com\/(\d+)/', $mat['vimeo_link'], $matches)) {
                        $src = 'https://player.vimeo.com/video/' . $matches[1];
                    }
                    $module_contents[] = ["type" => "video", "title" => $mat['title'], "src" => $src];
                } elseif ($doc_type === 'file') {
                    $materialFolder = ($mat['institute_id'] ?? 0) == 1 ? $superadminFolder : $currentFolder;
                    $ext = strtolower(pathinfo($mat['actual_file_name'], PATHINFO_EXTENSION));
                    $type = 'file';
                    if (in_array($ext, ['pdf'])) $type = 'pdf';
                    elseif (in_array($ext, ['ppt', 'pptx'])) $type = 'ppt';
                    elseif (in_array($ext, ['txt'])) $type = 'txt';
                    $module_contents[] = [
                        "type" => $type,
                        "title" => $mat['title'],
                        "src" => "institutes/{$materialFolder}/study_materials/" . $mat['actual_file_name']
                    ];
                }  else {
                    $module_contents[] = ["type" => "text", "title" => $mat['title'], "content" => $mat['description']];
                }
            }
        }

        // Module-level quiz
        $stmtQuiz = $pdo->prepare("SELECT quiz_id FROM course_quiz WHERE module_id = ? AND course_id = ?");
        $stmtQuiz->execute([$module_id, $course_id]);
        $quizEntry = $stmtQuiz->fetch(PDO::FETCH_ASSOC);

        if ($quizEntry && !empty($quizEntry['quiz_id'])) {
            $quiz_id = (int)$quizEntry['quiz_id'];
            $alreadyExists = array_filter($module_contents, function($c) use ($quiz_id) {
                return $c['type'] === 'quiz' && (isset($c['quiz_id']) && $c['quiz_id'] == $quiz_id);
            });
            if (empty($alreadyExists)) {
                $module_contents[] = ["type" => "quiz", "title" => "Module Quiz", "quiz_id" => $quiz_id];
            }
        }

        // Submodules
        $stmtSub = $pdo->prepare("SELECT submodule_id FROM course_submodule WHERE course_id = ? AND module_id = ? ORDER BY sequence ASC");
        $stmtSub->execute([$course_id, $module_id]);
        $submodule_ids = $stmtSub->fetchAll(PDO::FETCH_COLUMN);

        $submodules_array = [];

        foreach ($submodule_ids as $sub_id) {
            $stmtSubDetails = $pdo->prepare("SELECT submodule_name, study_material FROM submodule_master WHERE submodule_id = ?");
            $stmtSubDetails->execute([$sub_id]);
            $submodule = $stmtSubDetails->fetch(PDO::FETCH_ASSOC);
            if (!$submodule) continue;

            $sub_study_ids = array_filter(array_map('trim', explode(',', $submodule['study_material'])));
            $sub_contents = [];

            if (!empty($sub_study_ids)) {
                $placeholders = implode(',', array_fill(0, count($sub_study_ids), '?'));
                $stmtMat = $pdo->prepare("SELECT * FROM study_material WHERE study_material_id IN ($placeholders)");
                $stmtMat->execute($sub_study_ids);
                $materials = $stmtMat->fetchAll(PDO::FETCH_ASSOC);

                foreach ($materials as $mat) {
                    $doc_type = strtolower($mat['doc_type']);
                    if ($doc_type === 'video') {
                        $src = $mat['vimeo_link'];
                        if (preg_match('/https:\/\/vimeo\.com\/(\d+)/', $mat['vimeo_link'], $matches)) {
                            $src = 'https://player.vimeo.com/video/' . $matches[1];
                        }
                        $sub_contents[] = ["type" => "video", "title" => $mat['title'], "src" => $src];
                    } elseif ($doc_type === 'file') {
                        $materialFolder = ($mat['institute_id'] ?? 0) == 1 ? $superadminFolder : $currentFolder;
                        $ext = strtolower(pathinfo($mat['actual_file_name'], PATHINFO_EXTENSION));
                        $type = 'file';
                        if (in_array($ext, ['pdf'])) $type = 'pdf';
                        elseif (in_array($ext, ['ppt', 'pptx'])) $type = 'ppt';
                        elseif (in_array($ext, ['txt'])) $type = 'txt';
                        $sub_contents[] = [
                            "type" => $type,
                            "title" => $mat['title'],
                            "src" => "institutes/{$materialFolder}/study_materials/" . $mat['actual_file_name']
                        ];
                    }  else {
                        $sub_contents[] = ["type" => "text", "title" => $mat['title'], "content" => $mat['description']];
                    }
                }
            }

            $submodules_array[] = [
                "title" => $submodule['submodule_name'],
                "contents" => $sub_contents
            ];
        }

        // Assemble module output
        $module_submodules = [];
        if (!empty($module_contents)) {
            $module_submodules[] = ["title" => $module['module_name'], "contents" => $module_contents];
        }
        $module_submodules = array_merge($module_submodules, $submodules_array);

        $result[] = [
            "title" => $module['module_name'],
            "module_submodules_content" => $module_submodules
        ];
    }


// Step 5: Add assignments at the very end
$stmtAssignment = $pdo->prepare("
    SELECT 
        am.assignment_id, 
        am.assignment_title,
        IFNULL(aa.attempt_count, 1) AS attempt_count
    FROM course_assignment ca
    JOIN assignment_master am ON ca.assignment_id = am.assignment_id
    LEFT JOIN assignment_attempts aa 
        ON aa.assignment_id = am.assignment_id AND aa.user_id = :user_id
    WHERE ca.course_id = :course_id
    ORDER BY am.assignment_id DESC
    LIMIT 1
");

// Use associative array with named placeholders
$stmtAssignment->execute([
    ':course_id' => $course_id,
    ':user_id'   => $_SESSION['user_id'] ?? 0
]);

$assignment = $stmtAssignment->fetch(PDO::FETCH_ASSOC);

if (!empty($assignment)) {
    $assignment_contents = [[
        "type"          => "assignment",
        "title"         => $assignment['assignment_title'],
        "assignment_id" => (int)$assignment['assignment_id'],
        "attempt_count" => (int)$assignment['attempt_count']
    ]];

    $result[] = [
        "title" => "Assignments",
        "module_submodules_content" => [
            ["title" => "Assignments", "contents" => $assignment_contents]
        ]
    ];
}


    echo json_encode($result);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Server error", "details" => $e->getMessage()]);
}
