<?php
// apis/fetch_draft_quizzes.php

require_once('../includes/connection.php'); // Adjust path as necessary
session_start(); // Only if your session logic is needed for this API

header('Content-Type: application/json');

try {
    // Validate and get draft_id from GET parameters
    if (!isset($_GET['draft_id']) || !is_numeric($_GET['draft_id'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid or missing draft_id parameter.']);
        exit();
    }
    $draft_id = $_GET['draft_id'];

    // SQL to fetch assignments for the specific draft
    $sql = "
        SELECT
            cdq.course_draft_quiz_id,
            cdq.quiz_id,
            cdq.module_id,
            cdq.submodule_id
        FROM course_draft_quiz cdq
        WHERE cdq.course_draft_id = :draft_id
        ORDER BY cdq.course_draft_quiz_id DESC
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':draft_id', $draft_id, PDO::PARAM_INT);
    $stmt->execute();

    $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['success' => true, 'assignments' => $assignments]);

} catch (PDOException $e) {
    error_log("Database error in fetch_draft_quizzes.php: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error occurred.']);
} catch (Exception $e) {
    error_log("General error in fetch_draft_quizzes.php: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'An unexpected error occurred.']);
}
?>