<?php
require_once('../includes/connection.php');

// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Ensure institute_id is available
if (!isset($_SESSION['institute_id'])) {
    echo json_encode(['error' => 'Institute ID not set in session']);
    exit;
}

$institute_id = $_SESSION['institute_id'];
$moduleId = isset($_GET['module_id']) ? intval($_GET['module_id']) : null;

if ($moduleId) {
    try {
        // Fetch submodules linked to the selected module using FIND_IN_SET
        $sql = "SELECT sm.submodule_id AS id, sm.submodule_name AS name
                FROM submodule_master sm
                JOIN module_master mm ON FIND_IN_SET(sm.submodule_id, mm.sub_module_id) > 0
                WHERE sm.institute_id = :institute_id 
                AND mm.module_id = :module_id 
                AND sm.is_block != 1
                ORDER BY sm.submodule_id ASC";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':institute_id', $institute_id, PDO::PARAM_INT);
        $stmt->bindParam(':module_id', $moduleId, PDO::PARAM_INT);
        $stmt->execute();

        $submodules = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($submodules);

    } catch (PDOException $e) {
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'Module ID is required']);
}
?>
