<?php
session_start();
ob_start();
header('Content-Type: application/json');
date_default_timezone_set('Asia/Kolkata');

require_once('../includes/connection.php');
require_once('../includes/PHPMailerAutoload.php');
require_once('../includes/class.phpmailer.php');
require_once('../includes/class.smtp.php');

$data = json_decode(file_get_contents("php://input"), true);
$email = trim($data['email']);

try {
    // 1. Check if email exists
    $stmt = $pdo->prepare("SELECT * FROM user_master WHERE email_id = :email");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode(['status' => false, 'message' => 'This email is not registered.']);
        exit;
    }

    // 2. Generate token + expiry
    $token = bin2hex(random_bytes(32));
    $expires_at = date('Y-m-d H:i:s', strtotime('+1 hour'));

    // 3. Remove existing reset requests for the email
    $pdo->prepare("DELETE FROM password_reset WHERE email = :email")->execute(['email' => $email]);

    // 4. Store new token
    $pdo->prepare("
        INSERT INTO password_reset (email, token, expires_at)
        VALUES (:email, :token, :expires_at)
    ")->execute([
        'email' => $email,
        'token' => $token,
        'expires_at' => $expires_at
    ]);

    // 5. Prepare reset link
    $reset_link = "https://kapps.co.in/EPIC_LMS/reset_password.php?token=$token";

    // 6. Send email
    $mail = new PHPMailer(true);
    $mail->isSMTP();
    $mail->Host = 'smtp.gmail.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'yusuf@kalpaksolutions.com';
    $mail->Password = 'enoh kfxy ixyq xldg';
    $mail->SMTPSecure = 'tls';
    $mail->Port = 587;

    $mail->setFrom('yusuf@kalpaksolutions.com', 'LMS');
    $mail->addAddress($email);

    $mail->isHTML(true);
    $mail->Subject = 'EPIC LMS - Forgot Password Request';
$mail->Body = <<<EOD
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <style>
    body {
      margin: 0;
      padding: 0;
      background-color: #f6f6f6;
      font-family: Poppins, sans-serif;
      color: #333;
    }
    
    .email-container {
      max-width: 600px;
      margin: 40px auto;
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 5px 25px rgba(0, 0, 0, 0.1);
      overflow: hidden;
      width: 99%;
    }

    .email-header {
      background: linear-gradient(135deg, #5C2C8B, #7C43BD);
      padding: 30px;
      text-align: center;
      color: #ffffff;
    }

    .email-header img {
      max-height: 60px;
      margin-bottom: 15px;
    }

    .email-header h1 {
      margin: 0;
      font-size: 26px;
      font-weight: 600;
    }

    .email-body {
      padding: 30px;
    }

    .email-body h2 {
      font-size: 22px;
      color: #5C2C8B;
      margin-top: 0;
    }

    .email-body p {
      line-height: 1.6;
      margin-bottom: 20px;
    }

    .login-button {
      display: inline-block;
      background-color: #5C2C8B;
      color: #fff !important;
      padding: 12px 24px;
      border-radius: 6px;
      text-decoration: none;
      font-weight: bold;
      margin-top: 10px;
      transition: background 0.3s ease;
    }

    .login-button:hover {
      background-color: #45216a;
    }

    .email-footer {
      background-color: #fafafa;
      padding: 15px;
      text-align: center;
      font-size: 12px;
      color: #777;
    }
  </style>
</head>
<body>

  <div class="email-container">
    <div class="email-header">
      <img src="https://kapps.co.in/EPIC_LMS/images/logo.png" alt="EPIC LMS">
      <h2>EPIC LMS - Forgot Password Request</h2>
    </div>

    <div class="email-body">
      <h2>Hi there,</h2>
      <p>We received a request to reset the password for your account associated with this email address.</p>

      <p>Click the button below to reset your password. This link will remain valid for <strong>1 hour</strong>.</p>

      <a href="$reset_link" class="login-button">Reset Password</a>

      <p>If you did not request a password reset, you can safely ignore this email. No changes will be made unless you click the link above.</p>
    </div>

    <div class="email-footer">
      &copy; 2025 EPIC LMS. This is an automated message — please do not reply.
    </div>
  </div>

</body>
</html>
EOD;


    $mail->send();

    if (ob_get_length()) ob_clean();
    echo json_encode(['status' => true, 'message' => 'Password reset link has been sent to your email.']);
    exit;

} catch (Exception $e) {
    if (ob_get_length()) ob_clean();
    echo json_encode(['status' => false, 'message' => 'Server Error: ' . $e->getMessage()]);
    exit;
}