<?php

// Rest of your code
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['submodule_id'])) {
    echo json_encode(["status" => "error", "message" => "Sub Module ID is required"]);
    exit();
}

$submoduleId = $_GET['submodule_id']; // Correct variable name to match the parameter passed

// Fetch assigned study materials for the given module ID
$query = "SELECT study_material FROM submodule_master WHERE submodule_id = :submodule_id";
$stmt = $pdo->prepare($query);
$stmt->bindParam(':submodule_id', $submoduleId, PDO::PARAM_INT);
$stmt->execute();

$assignedMaterials = $stmt->fetchAll(PDO::FETCH_COLUMN);

echo json_encode($assignedMaterials);
?>
