<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Assignment ID is required"]);
    exit();
}

$assignmentId = base64_decode($_GET['id']);;

try {
    // Assuming a PDO connection is available as $pdo
    $sql = "SELECT * FROM assignment_master WHERE assignment_id = :assignment_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':assignment_id', $assignmentId);
    $stmt->execute();
    $assignment = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($assignment) {
        echo json_encode(["status" => "success", "assignment" => $assignment]);
    } else {
        echo json_encode(["status" => "error", "message" => "assignment not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
