<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Category ID is required"]);
    exit();
}

$categoryId = base64_decode($_GET['id']);

try {
    // Assuming a PDO connection is available as $pdo
    $sql = "SELECT category_name, is_block FROM category_master WHERE category_id = :category_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':category_id', $categoryId);
    $stmt->execute();
    $category = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($category) {
        echo json_encode(["status" => "success", "category" => $category]);
    } else {
        echo json_encode(["status" => "error", "message" => "Category not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
