<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

if (!isset($_GET['id']) || empty($_GET['id'])) {
    http_response_code(400);
    echo json_encode(["error" => "Missing course ID"]);
    exit;
}

$course_id = intval($_GET['id']);

try {
    // Get course title and mentor IDs from course_master
    $stmt = $pdo->prepare("
        SELECT cm.course_title, cm.mentor_ids, cm.start_date, cm.end_date
        FROM course_master cm
        WHERE cm.course_id = ?
    ");
    $stmt->execute([$course_id]);
    $course = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$course) {
        echo json_encode(["error" => "Course not found"]);
        exit;
    }

    // Extract mentor_ids (assumed to be a comma-separated list)
    $mentor_ids = explode(',', $course['mentor_ids']);

    // Get mentor names from mentor_master using JOIN
    $in_query = implode(',', array_fill(0, count($mentor_ids), '?'));
    $stmt = $pdo->prepare("
        SELECT mentor_name
        FROM mentor_master
        WHERE mentor_id IN ($in_query)
    ");
    $stmt->execute($mentor_ids);
    $mentors = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Join all mentor names into a single string
    $mentor_names = implode(", ", $mentors);

    // -------------------------
    // Fetch completed_date based on attempt_count = 3
    // -------------------------
    $user_id = $_SESSION['user_id'] ?? null;
    $institute_id = $_SESSION['institute_id'] ?? null;

    $completed_date = null;

    if ($user_id && $institute_id) {
        $sql = "
            SELECT MAX(a.created_date) AS completed_date
            FROM assignment_attempts a
            WHERE a.user_id = :user_id
              AND a.institute_id = :institute_id
              AND a.course_id = :course_id
              AND a.attempt_count = 3
        ";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':user_id' => $user_id,
            ':institute_id' => $institute_id,
            ':course_id' => $course_id
        ]);
        $completed_date_raw = $stmt->fetchColumn();

        if ($completed_date_raw) {
            $dt = new DateTime($completed_date_raw);
            $completed_date = $dt->format('d F Y'); // e.g., 28 September 2025
        }
    }

    $response = [
        "course_details" => [
            "course_title" => $course['course_title'],
            "start_date" => $course['start_date'],
            "end_date" => $course['end_date'],
            "mentor_names" => $mentor_names,
            "completed_date" => $completed_date
        ]
    ];

    echo json_encode($response);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Server error", "details" => $e->getMessage()]);
}
