<?php
require_once('../includes/connection.php');
session_start();

header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? 0;
$course_id = $_GET['course_id'] ?? 0;

if (!$user_id || !$course_id) {
  echo json_encode(['status' => 'error', 'message' => 'Missing data']);
  exit;
}

try {
  $stmt = $pdo->prepare("SELECT last_content_index, max_completed_index FROM user_course_progress WHERE user_id = :user_id AND course_id = :course_id");
  $stmt->execute([
    ':user_id' => $user_id,
    ':course_id' => $course_id
  ]);
  $result = $stmt->fetch(PDO::FETCH_ASSOC);

  echo json_encode(['status' => 'success', 'data' => $result ?: 'NOTSTARTED']);
} catch (PDOException $e) {
  echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>