<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method'
    ]);
    exit;
}

if (empty($_POST['notification_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing notification_id'
    ]);
    exit;
}

$notificationId = (int) $_POST['notification_id'];

try {

    $sql = "
        SELECT 
            sn.notification_id,
            sn.email_title,
            sn.subject,
            sn.email_content,
            sn.course_id,
            sn.institute_id,
            cm.course_title,
            im.institute_name
        FROM student_notifications sn
        LEFT JOIN course_master cm 
            ON cm.course_id = sn.course_id
        LEFT JOIN institute_master im 
            ON im.institute_id = sn.institute_id
        WHERE sn.notification_id = :notification_id
        LIMIT 1
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':notification_id', $notificationId, PDO::PARAM_INT);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Email content not found'
        ]);
        exit;
    }

    echo json_encode([
        'status' => 'success',
        'data' => [
            'notification_id' => $row['notification_id'],
            'email_title'     => $row['email_title'],
            'subject'         => $row['subject'],
            'email_content'   => $row['email_content'],
            'course_id'       => $row['course_id'],
            'course_title'    => $row['course_title'],
            'institute_id'    => $row['institute_id'],
            'institute_name'  => $row['institute_name']
        ]
    ]);

} catch (PDOException $e) {

    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}