<?php
require_once ('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Mentor ID is required"]);
    exit();
}

$institute_id = $_SESSION['institute_id'];
$mentorId = base64_decode($_GET['id']);

try {
    // Get current institute folder
    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }

    // Fetch mentor details
    $sql = "SELECT mentor_name, phone_no, email_id, password, specialization, linkedin_profile, photo, cv, industry_expert, is_block 
            FROM mentor_master 
            WHERE mentor_id = :mentor_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':mentor_id', $mentorId);
    $stmt->execute();
    $mentor = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($mentor) {
        $mentor['folder_name'] = $currentFolder;

        echo json_encode([
            "status" => "success",
            "mentor" => $mentor
        ]);
    } else {
        echo json_encode(["status" => "error", "message" => "Mentor not found"]);
    }

} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>