<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

if (!isset($_GET['draft_id'])) {
    echo json_encode(['success' => false, 'message' => 'draft_id missing']);
    exit;
}

$draft_id = intval($_GET['draft_id']);

try {
    // 1. Fetch modules for this draft
    $stmt = $pdo->prepare("
        SELECT cdm.draft_module_id, cdm.course_draft_id, cdm.module_id, mm.module_name, mm.description, mm.study_material
        FROM course_draft_modules cdm
        JOIN module_master mm ON cdm.module_id = mm.module_id
        WHERE cdm.course_draft_id = :draft_id
        ORDER BY cdm.draft_module_id ASC
    ");
    $stmt->execute(['draft_id' => $draft_id]);
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($modules as &$module) {
        $contents = [];

        // 2. If study_material is not empty
        if (!empty($module['study_material'])) {
            // 3. Convert comma separated string to array of IDs
            $materialIds = explode(',', $module['study_material']);
            
            // Clean IDs, make sure they are ints
            $materialIds = array_map('intval', $materialIds);
            
            if (count($materialIds) > 0) {
                // Prepare placeholders for IN clause
                $placeholders = implode(',', array_fill(0, count($materialIds), '?'));
                
                // 4. Fetch study materials by IDs
                $stmt2 = $pdo->prepare("SELECT study_material_id, title, actual_file_name FROM study_material WHERE study_material_id IN ($placeholders)");
                $stmt2->execute($materialIds);
                $contents = $stmt2->fetchAll(PDO::FETCH_ASSOC);
            }
        }
        
        // Add study materials as contents array to module
        $module['contents'] = $contents;
    }

    echo json_encode(['success' => true, 'modules' => $modules]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
