<?php
require_once ('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['question_id'])) {
    echo json_encode(["status" => "error", "message" => "Question ID is required"]);
    exit();
}

$institute_id = $_SESSION['institute_id'];

$questionId = base64_decode($_GET['question_id']);;

try {
    
    // Get current institute folder
    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }
    
    // Assuming a PDO connection is available as $pdo
    $sql = "SELECT * FROM question_master WHERE question_master_id  = :question_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':question_id', $questionId);
    $stmt->execute();
    $question = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($question) {
        
        $question['folder_name'] = $currentFolder;
        echo json_encode(["status" => "success", "question" => $question]);
    } else {
        echo json_encode(["status" => "error", "message" => "Question not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
