<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Quiz ID is required"]);
    exit();
}

$quizId = base64_decode($_GET['id']);;

try {
    // Assuming a PDO connection is available as $pdo
    $sql = "SELECT * FROM quiz_master WHERE quiz_id = :quiz_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':quiz_id', $quizId);
    $stmt->execute();
    $quiz = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($quiz) {
        echo json_encode(["status" => "success", "quiz" => $quiz]);
    } else {
        echo json_encode(["status" => "error", "message" => "Quiz not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>
