<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "FAQ ID is required"]);
    exit();
}

$faqId = intval(base64_decode($_GET['id'])); // Decode and validate ID


try {
    $sql = "SELECT faq_id, faq_question, faq_answer, created_date, is_block FROM faq_master WHERE faq_id = :faq_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':faq_id', $faqId, PDO::PARAM_INT);
    $stmt->execute();
    $faqs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($faqs) {
        echo json_encode(["status" => "success", "faqs" => $faqs]);
    } else {
        echo json_encode(["status" => "error", "message" => "No FAQs found."]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database Error: " . $e->getMessage()]);
}
?>
