<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Notification ID is required"]);
    exit;
}

$notification_template_id = intval(base64_decode($_GET['id']));

try {
    $sql = "
        SELECT email_title, subject, email_content
        FROM notification_template
        WHERE notification_template_id = :id
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $notification_template_id, PDO::PARAM_INT);
    $stmt->execute();

    $template = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($template) {
        echo json_encode([
            "status" => "success",
            "data"   => $template
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No notification found"
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database error"
    ]);
}