<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['quiz_id'])) {
    echo json_encode(["status" => "error", "message" => "Quiz ID is required"]);
    exit();
}

$quizId = intval($_GET['quiz_id']);

try {
    // Fetch quiz details
    $sql = "SELECT * FROM quiz_master WHERE quiz_id = :quiz_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':quiz_id', $quizId, PDO::PARAM_INT);
    $stmt->execute();
    $quiz = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($quiz) {
        $questionIds = array_filter(array_map('trim', explode(',', $quiz['question_ids'])));

        if (!empty($questionIds)) {
            $placeholders = rtrim(str_repeat('?,', count($questionIds)), ',');
            $qSql = "SELECT * FROM question_master WHERE question_master_id IN ($placeholders)";
            $qStmt = $pdo->prepare($qSql);
            $qStmt->execute($questionIds);
            $questions = $qStmt->fetchAll(PDO::FETCH_ASSOC);

            $formattedQuestions = array_map(function ($q) {
                $options = [
                    'option_1' => $q['option_1'],
                    'option_2' => $q['option_2'],
                    'option_3' => $q['option_3'],
                    'option_4' => $q['option_4'],
                ];

                $type = strtolower(trim($q['type']));
                $correctAnswerValues = [];

                if ($type === 'yes_no' || $type === 'true_false') {
                    // Normalize to lowercase
                    $val = strtolower(trim($q['correct_answer']));
                    if (!empty($val)) {
                        $correctAnswerValues[] = ucfirst($val); // "yes" → "Yes"
                    }
                } else {
                    // For One/Multiple Right Answer types
                    $correctAnswerKeys = array_map('trim', explode(',', $q['correct_answer']));
                    foreach ($correctAnswerKeys as $key) {
                        $keyFormatted = strtolower(str_replace(' ', '_', $key));
                        if (isset($options[$keyFormatted])) {
                            $correctAnswerValues[] = $options[$keyFormatted];
                        }
                    }

                    // If only one correct answer and type is not multiple
                    if ($type === 'one right answer' && count($correctAnswerValues) === 1) {
                        $correctAnswerValues = $correctAnswerValues[0]; // Return as string
                    }
                }

                return [
                    "question_id"     => $q["question_master_id"],
                    "type"            => $q["type"],
                    "question"        => $q["question"],
                    "media"           => [
                        "image"      => $q["image_url"],
                        "video"      => $q["video_url"],
                        "video_type" => $q["video_type"]
                    ],
                    "options"         => array_values(array_filter($options)),
                    "correct_answer"  => $correctAnswerValues,
                    "hint"            => $q["hint"],
                    "marks"           => $q["marks"]
                ];
            }, $questions);

            echo json_encode([
                "status"       => "success",
                "quiz_title"   => $quiz['quiz_title'],
                "total_marks"  => $quiz['total_marks'],
                "questions"    => $formattedQuestions
            ]);
        } else {
            echo json_encode(["status" => "error", "message" => "No questions linked to this quiz."]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Quiz not found."]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database Error: " . $e->getMessage()]);
}
?>