<?php
require_once ('../includes/connection.php');

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["status" => "error", "message" => "Student ID is required"]);
    exit();
}

$studentId = base64_decode($_GET['id']);

try {
    // Assuming a PDO connection is available as $pdo
    $sql = "SELECT * FROM student_master WHERE student_id = :student_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':student_id', $studentId);
    $stmt->execute();
    $student = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($student) {
        // --- START OF MODIFICATION ---
        // Check if the 'password' key exists in the fetched student data
        // and if it's not empty, then Base64 decode it.
        if (isset($student['password']) && !empty($student['password'])) {
            $student['password'] = base64_decode($student['password']);
        }
        // --- END OF MODIFICATION ---

        echo json_encode(["status" => "success", "student" => $student]);
    } else {
        echo json_encode(["status" => "error", "message" => "Student not found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Error: " . $e->getMessage()]);
}
?>