<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');


if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo json_encode([
        'status' => 'success',
        'data' => [
            'email_title'   => '',
            'subject'       => '',
            'email_content' => '',
            'course_id'     => '',
            'institute_id'  => ''
        ]
    ]);
    exit;
}

$notification_id = (int) base64_decode($_GET['id']);

try {

    $sql = "
        SELECT 
            email_title,
            subject,
            email_content
        FROM notification_template
        WHERE notification_template_id = :id
        LIMIT 1
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([':id' => $notification_id]);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    /**
     * CASE 2: ID present but no record found
     */
    if (!$data) {
        echo json_encode([
            'status'  => 'error',
            'message' => 'Template not found'
        ]);
        exit;
    }

    /**
     * CASE 3: Record found
     */
    echo json_encode([
        'status' => 'success',
        'data'   => $data
    ]);

} catch (PDOException $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Database error'
    ]);
}