<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');
$institute_id = $_SESSION['institute_id'];
// $course_id = isset($_GET['course_id']) ? $_GET['course_id'] : null; // Ensure course_id is passed

// if (!$course_id) {
//     echo json_encode(['error' => 'Course ID is required']);
//     exit;
// }

try {
    // Fetch module_id and module_name by joining course_module and module_master
    $stmt = $pdo->prepare("
        SELECT m.module_id AS id, m.module_name AS name
        FROM module_master m
        WHERE m.is_block != 1
        AND m.is_deleted != 1
        AND m.institute_id = :institute_id
    ");
    
    $stmt->execute([':institute_id' => $institute_id]);
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return response
    $response = ['modules' => $modules];
    echo json_encode($response);
    
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database Error: ' . $e->getMessage()]);
}
?>