<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $draw   = intval($_POST['draw'] ?? 1);
    $start  = intval($_POST['start'] ?? 0);
    $length = intval($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';

    $sortField = $_POST['sortField'] ?? 'notification_id';
    $sortDir   = strtoupper($_POST['sortDir'] ?? 'DESC');

    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    $allowedSortFields = [
        'notification_id' => 'sn.notification_id',
        'email_title'     => 'sn.email_title',
        'subject'         => 'sn.subject',
        'course_title'    => 'cm.course_title'
    ];

    $orderBy = $allowedSortFields[$sortField] ?? 'sn.notification_id';

    $where = "WHERE 1=1";
    $params = [];

    if (!empty($searchValue)) {
        $where .= " AND (
            sn.email_title LIKE ?
            OR sn.subject LIKE ?
            OR cm.course_title LIKE ?
        )";
        $like = "%{$searchValue}%";
        $params = [$like, $like, $like];
    }


    $totalRecords = (int)$pdo
        ->query("SELECT COUNT(*) FROM student_notifications")
        ->fetchColumn();


    $countSql = "
        SELECT COUNT(*)
        FROM student_notifications sn
        LEFT JOIN course_master cm ON cm.course_id = sn.course_id
        $where
    ";
    $countStmt = $pdo->prepare($countSql);
    $countStmt->execute($params);
    $filteredRecords = (int)$countStmt->fetchColumn();

    $dataSql = "
        SELECT 
            sn.notification_id,
            sn.email_title,
            sn.subject,
            cm.course_title
        FROM student_notifications sn
        LEFT JOIN course_master cm ON cm.course_id = sn.course_id
        $where
        ORDER BY $orderBy $sortDir
        LIMIT ?, ?
    ";

    $dataStmt = $pdo->prepare($dataSql);
    $finalParams = array_merge($params, [$start, $length]);
    $dataStmt->execute($finalParams);

    echo json_encode([
        "draw"            => $draw,
        "recordsTotal"    => $totalRecords,
        "recordsFiltered" => $filteredRecords,
        "data"            => $dataStmt->fetchAll(PDO::FETCH_ASSOC)
    ]);

} catch (Exception $e) {
    echo json_encode([
        "error" => true,
        "message" => $e->getMessage()
    ]);
}